/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.manager.impl.commands;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.addon.manager.AddonManager;
import org.jboss.forge.container.addons.AddonId;
import org.jboss.forge.ui.UICommand;
import org.jboss.forge.ui.context.UIBuilder;
import org.jboss.forge.ui.context.UIContext;
import org.jboss.forge.ui.context.UIValidationContext;
import org.jboss.forge.ui.input.UIInput;
import org.jboss.forge.ui.metadata.UICommandMetadata;
import org.jboss.forge.ui.result.Result;
import org.jboss.forge.ui.result.Results;
import org.jboss.forge.ui.util.Metadata;

@Singleton
public class AddonInstallCommand
implements UICommand {
    @Inject
    private AddonManager addonManager;
    @Inject
    private UIInput<String> groupId;
    @Inject
    private UIInput<String> name;
    @Inject
    private UIInput<String> version;

    public UICommandMetadata getMetadata() {
        return Metadata.forCommand(this.getClass()).name("Install an Addon").description("Command to install a Forge 2 addon.");
    }

    public boolean isEnabled(UIContext context) {
        return true;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.initializeGroupIdInput(builder);
        this.initializeNameInput(builder);
        this.initializeVersionInput(builder);
    }

    private void initializeGroupIdInput(UIBuilder builder) {
        this.groupId.setLabel("Group Id:");
        this.groupId.setRequired(true);
        builder.add(this.groupId);
    }

    private void initializeNameInput(UIBuilder builder) {
        this.name.setLabel("Name:");
        this.name.setRequired(true);
        builder.add(this.name);
    }

    private void initializeVersionInput(UIBuilder builder) {
        this.version.setLabel("Version:");
        this.version.setRequired(true);
        builder.add(this.version);
    }

    public void validate(UIValidationContext context) {
    }

    public Result execute(UIContext context) {
        String coordinates = this.getCoordinates();
        try {
            this.addonManager.install(AddonId.fromCoordinates((String)coordinates)).perform();
            return Results.success((String)("Addon " + coordinates + " was installed succesfully."));
        }
        catch (Throwable t) {
            return Results.fail((String)("Addon " + coordinates + " could not be installed."), (Throwable)t);
        }
    }

    protected String getCoordinates() {
        return (String)this.groupId.getValue() + ':' + (String)this.name.getValue() + ',' + (String)this.version.getValue();
    }
}

