/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.manager.impl.commands;

import java.util.HashSet;
import java.util.Iterator;
import javax.inject.Inject;
import org.jboss.forge.addon.manager.AddonManager;
import org.jboss.forge.addon.manager.impl.commands.AddonCommandConstants;
import org.jboss.forge.container.Forge;
import org.jboss.forge.container.addons.AddonId;
import org.jboss.forge.container.repositories.AddonRepository;
import org.jboss.forge.container.repositories.MutableAddonRepository;
import org.jboss.forge.ui.UICommand;
import org.jboss.forge.ui.context.UIBuilder;
import org.jboss.forge.ui.context.UIContext;
import org.jboss.forge.ui.context.UIValidationContext;
import org.jboss.forge.ui.input.UISelectMany;
import org.jboss.forge.ui.metadata.UICommandMetadata;
import org.jboss.forge.ui.result.Result;
import org.jboss.forge.ui.result.Results;
import org.jboss.forge.ui.util.Metadata;

public class AddonRemoveCommand
implements UICommand,
AddonCommandConstants {
    @Inject
    private Forge forge;
    @Inject
    private AddonManager manager;
    @Inject
    private UISelectMany<AddonId> addons;

    public boolean isEnabled(UIContext context) {
        return true;
    }

    public UICommandMetadata getMetadata() {
        return Metadata.forCommand(this.getClass()).name("Remove an Addon").description("Command to remove a Forge 2 addon.");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.addons.setLabel("Installed addons");
        HashSet<AddonId> choices = new HashSet<AddonId>();
        for (AddonRepository repository : this.forge.getRepositories()) {
            if (!(repository instanceof MutableAddonRepository)) continue;
            for (AddonId id : repository.listEnabled()) {
                choices.add(id);
            }
        }
        this.addons.setValueChoices(choices);
        builder.add(this.addons);
    }

    public void validate(UIValidationContext context) {
    }

    public Result execute(UIContext context) throws Exception {
        Iterator iterator = this.addons.getValue().iterator();
        StringBuilder builder = new StringBuilder();
        while (iterator.hasNext()) {
            AddonId addonId = (AddonId)iterator.next();
            builder.append(addonId.toCoordinates());
            this.manager.disable(addonId);
            this.manager.remove(addonId);
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return Results.success((String)("Removed addons: " + builder.toString()));
    }
}

