/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.manager.impl;

import javax.inject.Inject;
import org.jboss.forge.addon.manager.AddonManager;
import org.jboss.forge.addon.manager.DisableRequest;
import org.jboss.forge.addon.manager.InstallRequest;
import org.jboss.forge.addon.manager.RemoveRequest;
import org.jboss.forge.addon.manager.impl.DisableRequestImpl;
import org.jboss.forge.addon.manager.impl.InstallRequestImpl;
import org.jboss.forge.addon.manager.impl.RemoveRequestImpl;
import org.jboss.forge.container.Forge;
import org.jboss.forge.container.addons.AddonId;
import org.jboss.forge.dependencies.AddonDependencyResolver;
import org.jboss.forge.dependencies.DependencyNode;
import org.jboss.forge.dependencies.DependencyQuery;
import org.jboss.forge.dependencies.builder.DependencyQueryBuilder;

public class AddonManagerImpl
implements AddonManager {
    private AddonDependencyResolver resolver;
    private Forge forge;

    @Inject
    public AddonManagerImpl(Forge forge, AddonDependencyResolver resolver) {
        this.forge = forge;
        this.resolver = resolver;
    }

    public InstallRequest install(AddonId id) {
        String coordinates = id.getName() + ":jar:forge-addon:" + id.getVersion();
        DependencyNode requestedAddonNode = this.resolver.resolveAddonDependencyHierarchy((DependencyQuery)DependencyQueryBuilder.create((String)coordinates));
        return new InstallRequestImpl(this, this.forge, requestedAddonNode);
    }

    public RemoveRequest remove(AddonId id) {
        return new RemoveRequestImpl(this, this.forge, id);
    }

    public DisableRequest disable(AddonId id) {
        return new DisableRequestImpl(this, this.forge, id);
    }
}

