/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.manager.impl;

import org.jboss.forge.addon.manager.AddonManager;
import org.jboss.forge.addon.manager.DisableRequest;
import org.jboss.forge.container.Forge;
import org.jboss.forge.container.addons.AddonId;
import org.jboss.forge.container.repositories.AddonRepository;
import org.jboss.forge.container.repositories.MutableAddonRepository;
import org.jboss.forge.container.util.Assert;

public class DisableRequestImpl
implements DisableRequest {
    private AddonManager manager;
    private Forge forge;
    private AddonId id;

    public DisableRequestImpl(AddonManager manager, Forge forge, AddonId id) {
        Assert.notNull((Object)manager, (String)"AddonManager must not be null.");
        Assert.notNull((Object)forge, (String)"Forge must not be null.");
        Assert.notNull((Object)id, (String)"AddonId must not be null.");
        this.manager = manager;
        this.forge = forge;
        this.id = id;
    }

    public AddonId getAddonIdToDisable() {
        return null;
    }

    public void perform() {
        for (AddonRepository repository : this.forge.getRepositories()) {
            if (!(repository instanceof MutableAddonRepository) || !repository.isEnabled(this.id)) continue;
            ((MutableAddonRepository)repository).disable(this.id);
        }
    }

    public void perform(AddonRepository repository) {
        if (!(repository instanceof MutableAddonRepository)) {
            throw new IllegalArgumentException("Cannot remove addons from an immutable AddonRepository (must implement MutableAddonRepository.");
        }
        ((MutableAddonRepository)repository).disable(this.id);
    }
}

