/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.manager.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import org.jboss.forge.addon.manager.AddonManager;
import org.jboss.forge.addon.manager.InstallRequest;
import org.jboss.forge.addon.manager.impl.filters.DirectAddonFilter;
import org.jboss.forge.addon.manager.impl.filters.LocalResourceFilter;
import org.jboss.forge.container.Forge;
import org.jboss.forge.container.addons.AddonId;
import org.jboss.forge.container.lock.LockMode;
import org.jboss.forge.container.repositories.AddonDependencyEntry;
import org.jboss.forge.container.repositories.AddonRepository;
import org.jboss.forge.container.repositories.MutableAddonRepository;
import org.jboss.forge.container.util.Predicate;
import org.jboss.forge.dependencies.Coordinate;
import org.jboss.forge.dependencies.DependencyNode;
import org.jboss.forge.dependencies.collection.DependencyNodeUtil;

public class InstallRequestImpl
implements InstallRequest {
    private AddonManager addonManager;
    private Forge forge;
    private DependencyNode requestedAddonNode;
    private Stack<DependencyNode> requiredAddons = new Stack();
    private Stack<DependencyNode> optionalAddons = new Stack();
    private Logger log = Logger.getLogger(this.getClass().getName());

    InstallRequestImpl(AddonManager addonManager, Forge forge, DependencyNode requestedAddonNode) {
        this.addonManager = addonManager;
        this.forge = forge;
        this.requestedAddonNode = requestedAddonNode;
        Iterator iterator = DependencyNodeUtil.breadthFirstIterator((DependencyNode)requestedAddonNode);
        while (iterator.hasNext()) {
            DependencyNode node = (DependencyNode)iterator.next();
            if (!DependencyNodeUtil.isForgeAddon((Coordinate)node.getDependency().getCoordinate()) || node.equals(requestedAddonNode)) continue;
            if (node.getDependency().isOptional()) {
                this.optionalAddons.push(node);
                continue;
            }
            this.requiredAddons.push(node);
        }
    }

    public DependencyNode getRequestedAddon() {
        return this.requestedAddonNode;
    }

    public List<DependencyNode> getOptionalAddons() {
        return Collections.unmodifiableList(this.optionalAddons);
    }

    public List<DependencyNode> getRequiredAddons() {
        return Collections.unmodifiableList(this.requiredAddons);
    }

    public void perform() {
        this.forge.getLockManager().performLocked(LockMode.WRITE, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (DependencyNode requiredAddon : InstallRequestImpl.this.getRequiredAddons()) {
                    AddonId requiredAddonId = InstallRequestImpl.this.toAddonId(requiredAddon);
                    boolean deployed = false;
                    for (AddonRepository repository : InstallRequestImpl.this.forge.getRepositories()) {
                        if (!repository.isDeployed(requiredAddonId)) continue;
                        InstallRequestImpl.this.log.info("Addon " + requiredAddonId + " is already deployed. Skipping...");
                        deployed = true;
                        break;
                    }
                    if (deployed) continue;
                    InstallRequestImpl.this.addonManager.install(requiredAddonId).perform();
                }
                AddonId requestedAddonId = InstallRequestImpl.this.toAddonId(InstallRequestImpl.this.requestedAddonNode);
                for (AddonRepository repository : InstallRequestImpl.this.forge.getRepositories()) {
                    if (!(repository instanceof MutableAddonRepository)) continue;
                    MutableAddonRepository mutableRespository = (MutableAddonRepository)repository;
                    InstallRequestImpl.this.deploy(mutableRespository, requestedAddonId, InstallRequestImpl.this.requestedAddonNode);
                    mutableRespository.enable(requestedAddonId);
                    break;
                }
                return null;
            }
        });
    }

    public void perform(final AddonRepository target) {
        this.forge.getLockManager().performLocked(LockMode.WRITE, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (DependencyNode requiredAddon : InstallRequestImpl.this.getRequiredAddons()) {
                    AddonId requiredAddonId = InstallRequestImpl.this.toAddonId(requiredAddon);
                    boolean deployed = false;
                    for (AddonRepository repository : InstallRequestImpl.this.forge.getRepositories()) {
                        if (!repository.isDeployed(requiredAddonId)) continue;
                        InstallRequestImpl.this.log.info("Addon " + requiredAddonId + " is already deployed. Skipping...");
                        deployed = true;
                        break;
                    }
                    if (deployed) continue;
                    InstallRequestImpl.this.addonManager.install(requiredAddonId).perform(target);
                }
                AddonId requestedAddonId = InstallRequestImpl.this.toAddonId(InstallRequestImpl.this.requestedAddonNode);
                if (!(target instanceof MutableAddonRepository)) {
                    throw new IllegalArgumentException("Addon repository [" + target.getRootDirectory().getAbsolutePath() + "] is not writable.");
                }
                MutableAddonRepository mutableRespository = (MutableAddonRepository)target;
                InstallRequestImpl.this.deploy(mutableRespository, requestedAddonId, InstallRequestImpl.this.requestedAddonNode);
                mutableRespository.enable(requestedAddonId);
                return null;
            }
        });
    }

    private AddonId toAddonId(DependencyNode node) {
        Coordinate coord = node.getDependency().getCoordinate();
        DependencyNode forgeApi = (DependencyNode)DependencyNodeUtil.selectFirst((Iterator)DependencyNodeUtil.breadthFirstIterator((DependencyNode)node), (Predicate)new Predicate<DependencyNode>(){

            public boolean accept(DependencyNode node) {
                Coordinate coordinate = node.getDependency().getCoordinate();
                return "org.jboss.forge".equals(coordinate.getGroupId()) && "forge-addon-container-api".equals(coordinate.getArtifactId());
            }
        });
        String apiVersion = null;
        if (forgeApi != null) {
            apiVersion = forgeApi.getDependency().getCoordinate().getVersion();
        }
        return AddonId.from((String)(coord.getGroupId() + ":" + coord.getArtifactId()), (String)coord.getVersion(), (String)apiVersion);
    }

    private void deploy(MutableAddonRepository repository, AddonId addon, DependencyNode root) {
        List<AddonDependencyEntry> addonDependencies;
        List<File> resourceJars = this.toResourceJars(DependencyNodeUtil.select((DependencyNode)root, (Predicate)new LocalResourceFilter(root)));
        if (resourceJars.isEmpty()) {
            this.log.fine("No resource JARs found for " + addon);
        }
        if ((addonDependencies = this.toAddonDependencies(DependencyNodeUtil.select(root.getChildren().iterator(), (Predicate)new DirectAddonFilter(root)))).isEmpty()) {
            this.log.fine("No dependencies found for addon " + addon);
        }
        this.log.info("Deploying addon " + addon);
        repository.deploy(addon, addonDependencies, resourceJars);
    }

    private List<AddonDependencyEntry> toAddonDependencies(List<DependencyNode> dependencies) {
        ArrayList<AddonDependencyEntry> addonDependencies = new ArrayList<AddonDependencyEntry>();
        for (DependencyNode dep : dependencies) {
            boolean export = false;
            boolean optional = dep.getDependency().isOptional();
            String scopeType = dep.getDependency().getScopeType();
            if (scopeType != null && !optional) {
                if ("compile".equalsIgnoreCase(scopeType) || "runtime".equalsIgnoreCase(scopeType)) {
                    export = true;
                } else if ("provided".equalsIgnoreCase(scopeType)) {
                    export = false;
                }
            }
            AddonDependencyEntry addonDep = AddonDependencyEntry.create((AddonId)this.toAddonId(dep), (boolean)export, (boolean)optional);
            addonDependencies.add(addonDep);
        }
        return addonDependencies;
    }

    private List<File> toResourceJars(List<DependencyNode> dependencies) {
        ArrayList<File> result = new ArrayList<File>();
        for (DependencyNode dependency : dependencies) {
            result.add((File)dependency.getDependency().getArtifact().getUnderlyingResourceObject());
        }
        return result;
    }

    public String toString() {
        return DependencyNodeUtil.prettyPrint((DependencyNode)this.requestedAddonNode, (Predicate)new Predicate<DependencyNode>(){

            public boolean accept(DependencyNode node) {
                return DependencyNodeUtil.isForgeAddon((Coordinate)node.getDependency().getCoordinate()) && !node.getDependency().isOptional();
            }
        });
    }
}

