/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.aesh;

import java.io.File;
import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.CommandLineCompletionParser;
import org.jboss.aesh.cl.ParsedCompleteObject;
import org.jboss.aesh.cl.internal.ParameterInt;
import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.complete.Completion;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.Console;
import org.jboss.aesh.console.ConsoleOutput;
import org.jboss.aesh.util.FileLister;
import org.jboss.forge.aesh.ForgeShell;
import org.jboss.forge.aesh.ShellContext;
import org.jboss.forge.aesh.util.CommandLineUtil;
import org.jboss.forge.ui.UICommand;
import org.jboss.forge.ui.context.UIBuilder;
import org.jboss.forge.ui.context.UIContext;
import org.jboss.forge.ui.input.InputComponent;
import org.jboss.forge.ui.input.UIInput;
import org.jboss.forge.ui.input.UIInputMany;
import org.jboss.forge.ui.result.Result;

public class ShellCommand
implements Completion {
    private UICommand command;
    private ShellContext context;
    private ForgeShell aeshell;

    public ShellCommand(UICommand command, ForgeShell aeshell) throws Exception {
        this.command = command;
        this.context = new ShellContext(aeshell);
        this.aeshell = aeshell;
        command.initializeUI((UIBuilder)this.context);
        this.generateParser(command);
    }

    public Console getConsole() {
        return this.aeshell.getConsole();
    }

    public ShellContext getContext() {
        return this.context;
    }

    public ForgeShell getAeshell() {
        return this.aeshell;
    }

    public UICommand getCommand() {
        return this.command;
    }

    public void generateParser(UICommand command) {
        this.context.setParser(CommandLineUtil.generateParser(command, this.context));
    }

    public CommandLine parse(String line) throws IllegalArgumentException {
        return this.context.getParser().parse(line);
    }

    public void run(ConsoleOutput consoleOutput, CommandLine commandLine) throws Exception {
        CommandLineUtil.populateUIInputs(commandLine, this.context, this.getAeshell().getRegistry());
        this.context.setConsoleOutput(consoleOutput);
        Result result = this.command.execute((UIContext)this.context);
        if (result != null && result.getMessage() != null && result.getMessage().length() > 0) {
            this.getConsole().pushToStdOut(result.getMessage() + Config.getLineSeparator());
        }
    }

    public boolean isStandalone() {
        return this.context.isStandalone();
    }

    public void complete(CompleteOperation completeOperation) {
        ParameterInt param = (ParameterInt)this.context.getParser().getParameters().get(0);
        if (param.getName().startsWith(completeOperation.getBuffer())) {
            completeOperation.addCompletionCandidate(param.getName());
        } else if (completeOperation.getBuffer().startsWith(param.getName())) {
            ParsedCompleteObject completeObject = new CommandLineCompletionParser(this.context.getParser()).findCompleteObject(completeOperation.getBuffer());
            if (completeObject.doDisplayOptions()) {
                if (param.getOptionLongNamesWithDash().size() > 1) {
                    completeOperation.addCompletionCandidates(param.getOptionLongNamesWithDash());
                } else {
                    completeOperation.addCompletionCandidates(param.getOptionLongNamesWithDash());
                    completeOperation.setOffset(completeOperation.getCursor() - completeObject.getOffset());
                }
            } else if (completeObject.isOption()) {
                InputComponent<?, ?> inputOption = this.context.findInput(completeObject.getName());
                if (inputOption != null && inputOption.getValueType() == File.class) {
                    completeOperation.setOffset(completeOperation.getCursor());
                    if (completeObject.getValue() == null) {
                        new FileLister("", new File(System.getProperty("user.dir"))).findMatchingDirectories(completeOperation);
                    } else {
                        new FileLister(completeObject.getValue(), new File(System.getProperty("user.dir"))).findMatchingDirectories(completeOperation);
                    }
                } else if (inputOption == null || inputOption.getValueType() == Boolean.class) {
                    // empty if block
                }
                if (inputOption != null && inputOption instanceof UIInput) {
                    Iterable iter = ((UIInput)inputOption).getCompleter().getCompletionProposals(inputOption, completeObject.getValue());
                    if (iter != null) {
                        for (String s : iter) {
                            completeOperation.addCompletionCandidate(s);
                        }
                    }
                    if (completeOperation.getCompletionCandidates().size() == 1) {
                        completeOperation.setOffset(completeOperation.getCursor() - completeObject.getOffset());
                    }
                }
            } else if (completeObject.isArgument()) {
                InputComponent<?, ?> inputOption = this.context.findInput("arguments");
                if (inputOption != null && inputOption.getValueType() == File.class) {
                    completeOperation.setOffset(completeOperation.getCursor());
                    if (completeObject.getValue() == null) {
                        new FileLister("", new File(System.getProperty("user.dir"))).findMatchingDirectories(completeOperation);
                    } else {
                        new FileLister(completeObject.getValue(), new File(System.getProperty("user.dir"))).findMatchingDirectories(completeOperation);
                    }
                } else if (inputOption == null || inputOption.getValueType() != Boolean.class) {
                    if (this.command instanceof Completion) {
                        ((Completion)this.command).complete(completeOperation);
                    } else if (inputOption != null && inputOption instanceof UIInputMany) {
                        Iterable iter = ((UIInputMany)inputOption).getCompleter().getCompletionProposals(inputOption, completeObject.getValue());
                        if (iter != null) {
                            for (String s : iter) {
                                completeOperation.addCompletionCandidate(s);
                            }
                        }
                        if (completeOperation.getCompletionCandidates().size() == 1) {
                            completeOperation.setOffset(completeOperation.getCursor() - completeObject.getOffset());
                        }
                    }
                }
            }
        }
    }

    public String toString() {
        return "ShellCommand{command=" + this.command + ", context=" + (Object)((Object)this.context) + ", aeshell=" + this.aeshell + '}';
    }
}

