/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.aesh.commands;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.jboss.forge.container.addons.Addon;
import org.jboss.forge.container.addons.AddonRegistry;
import org.jboss.forge.ui.UICommand;
import org.jboss.forge.ui.context.UIBuilder;
import org.jboss.forge.ui.context.UIContext;
import org.jboss.forge.ui.context.UIValidationContext;
import org.jboss.forge.ui.metadata.UICommandMetadata;
import org.jboss.forge.ui.result.Result;
import org.jboss.forge.ui.result.Results;
import org.jboss.forge.ui.util.Metadata;

public class ListServicesCommand
implements UICommand {
    private AddonRegistry registry;

    @Inject
    public ListServicesCommand(AddonRegistry registry) {
        this.registry = registry;
    }

    public UICommandMetadata getMetadata() {
        return Metadata.forCommand(this.getClass()).name("list-services").description("List all available services");
    }

    public boolean isEnabled(UIContext context) {
        return true;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
    }

    public void validate(UIValidationContext context) {
    }

    public Result execute(UIContext context) throws Exception {
        return Results.success((String)this.listServices());
    }

    private String listServices() throws IOException {
        StringBuilder builder = new StringBuilder();
        Set addons = this.registry.getAddons();
        for (Addon addon : addons) {
            Set serviceClasses = addon.getServiceRegistry().getServices();
            for (Class type : serviceClasses) {
                builder.append(type.getName()).append("\n");
                for (Method method : type.getMethods()) {
                    builder.append("\n\type - " + this.getName(method));
                }
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    public String getName(Method method) {
        String params = "(";
        List<Class<?>> parameters = Arrays.asList(method.getParameterTypes());
        Iterator<Class<?>> iterator = parameters.iterator();
        while (iterator.hasNext()) {
            Class<?> p = iterator.next();
            params = params + p.getName();
            if (!iterator.hasNext()) continue;
            params = params + ",";
        }
        params = params + ")";
        String returnType = method.getReturnType().getName() == null ? "void" : method.getReturnType().getName();
        return method.getName() + params + "::" + returnType;
    }
}

