/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.aesh.commands;

import java.io.File;
import java.util.Iterator;
import javax.inject.Inject;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.Console;
import org.jboss.aesh.extensions.more.More;
import org.jboss.forge.aesh.ShellContext;
import org.jboss.forge.ui.UICommand;
import org.jboss.forge.ui.context.UIBuilder;
import org.jboss.forge.ui.context.UIContext;
import org.jboss.forge.ui.context.UIValidationContext;
import org.jboss.forge.ui.input.UIInputMany;
import org.jboss.forge.ui.metadata.UICommandMetadata;
import org.jboss.forge.ui.result.Result;
import org.jboss.forge.ui.result.Results;
import org.jboss.forge.ui.util.Metadata;

public class MoreCommand
implements UICommand {
    @Inject
    private UIInputMany<File> arguments;

    public UICommandMetadata getMetadata() {
        return Metadata.forCommand(this.getClass()).name("more").description("more \u2014 file perusal filter for crt viewing");
    }

    public boolean isEnabled(UIContext context) {
        return true;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.arguments.setLabel("");
        this.arguments.setRequired(false);
        builder.add(this.arguments);
    }

    public void validate(UIValidationContext validator) {
    }

    public Result execute(UIContext context) throws Exception {
        if (this.arguments.getValue() != null && context instanceof ShellContext) {
            Iterator iter = this.arguments.getValue().iterator();
            Console console = ((ShellContext)context).getShell().getConsole();
            File file = (File)this.arguments.getValue().iterator().next();
            if (file.getAbsolutePath().contains("~/")) {
                file = new File(Config.getHomeDir() + file.getAbsolutePath().substring(file.getAbsolutePath().indexOf("~/") + 1));
            }
            if (file.isFile()) {
                More more = new More(console);
                more.setFile(file);
                more.attach(((ShellContext)context).getConsoleOutput());
                return Results.success();
            }
            if (file.isDirectory()) {
                return Results.fail((String)(Config.getLineSeparator() + "*** " + file.getAbsolutePath() + " directory ***" + Config.getLineSeparator() + Config.getLineSeparator()));
            }
            return Results.fail((String)(file.getAbsolutePath() + " No such file or directory"));
        }
        return Results.fail((String)"Missing filename (\"more --help\" for help)");
    }
}

