/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.aesh.util;

import java.util.ArrayList;
import java.util.List;
import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.CommandLineParser;
import org.jboss.aesh.cl.OptionBuilder;
import org.jboss.aesh.cl.ParserBuilder;
import org.jboss.aesh.cl.internal.ParameterInt;
import org.jboss.forge.aesh.ShellContext;
import org.jboss.forge.container.addons.AddonRegistry;
import org.jboss.forge.convert.Converter;
import org.jboss.forge.convert.ConverterFactory;
import org.jboss.forge.ui.UICommand;
import org.jboss.forge.ui.input.InputComponent;
import org.jboss.forge.ui.input.UIInput;
import org.jboss.forge.ui.input.UIInputMany;

public class CommandLineUtil {
    private static ConverterFactory converterFactory = null;

    public static CommandLineParser generateParser(UICommand command, ShellContext context) {
        ParserBuilder builder = new ParserBuilder();
        ParameterInt parameter = new ParameterInt(command.getMetadata().getName(), command.getMetadata().getDescription());
        for (InputComponent<?, ?> input : context.getInputs()) {
            if (input.getName().equals("arguments")) continue;
            if (input.getValueType() == Boolean.class) {
                parameter.addOption(new OptionBuilder().name(input.getName().charAt(0)).longName(input.getName()).hasValue(false).description(input.getLabel()).create());
                continue;
            }
            parameter.addOption(new OptionBuilder().name(input.getName().charAt(0)).longName(input.getName()).description(input.getLabel()).create());
        }
        builder.addParameter(parameter);
        return builder.generateParser();
    }

    public static void populateUIInputs(CommandLine commandLine, ShellContext context, AddonRegistry registry) {
        for (InputComponent<?, ?> input : context.getInputs()) {
            if (commandLine.hasOption(input.getName()) && input instanceof UIInput) {
                String value = commandLine.getOptionValue(input.getName());
                CommandLineUtil.setInputValue((UIInput<Object>)((UIInput)input), value, registry);
                continue;
            }
            if (input.getName().equals("arguments") && input instanceof UIInputMany) {
                CommandLineUtil.setInputManyValue((UIInputMany)input, commandLine.getArguments(), registry);
                continue;
            }
            if (commandLine.hasOption(input.getName()) && input instanceof UIInputMany) continue;
            ((UIInput)input).setValue(null);
        }
    }

    private static void setInputManyValue(UIInputMany<?> input, List<String> values, AddonRegistry registry) {
        if (values != null && !values.isEmpty()) {
            ArrayList<Object> list = new ArrayList<Object>(values.size());
            if (converterFactory == null) {
                converterFactory = (ConverterFactory)registry.getExportedInstance(ConverterFactory.class).get();
            }
            for (String s : values) {
                Object convertedType = s;
                Class<?> source = s.getClass();
                Class target = input.getValueType();
                Converter converter = converterFactory.getConverter(source, target);
                convertedType = converter.convert((Object)s);
                list.add(convertedType);
            }
            input.setValue(list);
        }
    }

    private static void setInputValue(UIInput<Object> input, Object value, AddonRegistry registry) {
        Object convertedType = value;
        if (value != null) {
            if (converterFactory == null) {
                converterFactory = (ConverterFactory)registry.getExportedInstance(ConverterFactory.class).get();
            }
            Class<?> source = value.getClass();
            Class target = input.getValueType();
            if (converterFactory != null) {
                Converter converter = converterFactory.getConverter(source, target);
                convertedType = converter.convert(value);
            } else {
                System.err.println("Converter Factory was not deployed !! Cannot convert from " + source + " to " + target);
            }
        }
        input.setValue(convertedType);
    }
}

