/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.aesh;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.exception.ArgumentParserException;
import org.jboss.aesh.cl.exception.CommandLineParserException;
import org.jboss.aesh.cl.exception.OptionParserException;
import org.jboss.aesh.cl.exception.RequiredOptionException;
import org.jboss.aesh.complete.Completion;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.Console;
import org.jboss.aesh.console.ConsoleCallback;
import org.jboss.aesh.console.ConsoleOutput;
import org.jboss.aesh.console.Prompt;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.terminal.CharacterType;
import org.jboss.aesh.terminal.Color;
import org.jboss.aesh.terminal.TerminalCharacter;
import org.jboss.forge.aesh.ShellCommand;
import org.jboss.forge.aesh.spi.ShellStreamProvider;
import org.jboss.forge.container.Forge;
import org.jboss.forge.container.addons.Addon;
import org.jboss.forge.container.addons.AddonRegistry;
import org.jboss.forge.container.event.PostStartup;
import org.jboss.forge.container.event.PreShutdown;
import org.jboss.forge.container.services.Exported;
import org.jboss.forge.container.services.ExportedInstance;
import org.jboss.forge.ui.UICommand;

@Singleton
@Exported
public class ForgeShell {
    private static final Logger logger = Logger.getLogger(ForgeShell.class.getName());
    private Console console;
    private Prompt prompt;
    private List<ShellCommand> commands;
    @Inject
    private Forge forge;
    @Inject
    private Addon self;
    @Inject
    private AddonRegistry registry;

    void observe(@Observes PostStartup startup) throws Exception {
        this.startShell();
    }

    void stop(@Observes PreShutdown shutdown) throws Exception {
        if (this.console != null && this.console.isRunning()) {
            this.console.stop();
        }
    }

    public void addCommand(ShellCommand command) {
        this.commands.add(command);
        this.console.addCompletion((Completion)command);
    }

    private void initShell() throws Exception {
        this.prompt = this.createPrompt();
        for (ExportedInstance provider : this.registry.getExportedInstances(ShellStreamProvider.class)) {
            System.out.println("Loaded shell stream provider: " + provider);
        }
        Settings.getInstance().setReadInputrc(false);
        Settings.getInstance().setLogging(true);
        this.commands = new ArrayList<ShellCommand>();
        this.console = Console.getInstance();
        this.console.setPrompt(this.prompt);
        this.console.setConsoleCallback((ConsoleCallback)new ForgeConsoleCallback());
        for (ExportedInstance instance : this.registry.getExportedInstances(UICommand.class)) {
            UICommand command = (UICommand)instance.get();
            try {
                this.addCommand(new ShellCommand(command, this));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Could not load UICommand [" + command.getMetadata().getName() + "]", e);
            }
        }
    }

    private void verifyLoadedCommands() throws Exception {
        if (this.registry.getExportedInstances(UICommand.class).size() != this.commands.size()) {
            for (ExportedInstance instance : this.registry.getExportedInstances(UICommand.class)) {
                if (this.doCommandExist(((UICommand)instance.get()).getMetadata().getName())) continue;
                this.addCommand(new ShellCommand((UICommand)instance.get(), this));
            }
            Iterator<ShellCommand> iterable = this.commands.iterator();
            while (iterable.hasNext()) {
                if (this.isCommandFound(iterable.next().getCommand().getMetadata().getName(), this.registry.getExportedInstances(UICommand.class))) continue;
                iterable.remove();
            }
        }
    }

    private boolean doCommandExist(String name) {
        for (ShellCommand command : this.commands) {
            if (!command.getCommand().getMetadata().getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean isCommandFound(String name, Set<ExportedInstance<UICommand>> uiCommands) {
        for (ExportedInstance<UICommand> command : uiCommands) {
            if (!((UICommand)command.get()).getMetadata().getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void startShell() throws Exception {
        this.initShell();
        this.console.start();
    }

    public AddonRegistry getRegistry() {
        return this.registry;
    }

    public String getPrompt() {
        return this.prompt.getPromptAsString();
    }

    public Console getConsole() {
        return this.console;
    }

    public void stopShell() throws IOException {
        if (this.console != null && this.console.isRunning()) {
            this.console.stop();
            this.console.reset();
        }
    }

    private Prompt createPrompt() {
        ArrayList<TerminalCharacter> chars = new ArrayList<TerminalCharacter>();
        chars.add(new TerminalCharacter('[', Color.DEFAULT_BG, Color.BLUE_TEXT));
        chars.add(new TerminalCharacter('f', Color.DEFAULT_BG, Color.RED_TEXT, CharacterType.BOLD));
        chars.add(new TerminalCharacter('o', Color.DEFAULT_BG, Color.RED_TEXT, CharacterType.BOLD));
        chars.add(new TerminalCharacter('r', Color.DEFAULT_BG, Color.RED_TEXT, CharacterType.BOLD));
        chars.add(new TerminalCharacter('g', Color.DEFAULT_BG, Color.RED_TEXT, CharacterType.BOLD));
        chars.add(new TerminalCharacter('e', Color.DEFAULT_BG, Color.RED_TEXT, CharacterType.BOLD));
        chars.add(new TerminalCharacter(']', Color.DEFAULT_BG, Color.BLUE_TEXT, CharacterType.PLAIN));
        chars.add(new TerminalCharacter('$', Color.DEFAULT_BG, Color.DEFAULT_TEXT));
        chars.add(new TerminalCharacter(' ', Color.DEFAULT_BG, Color.DEFAULT_TEXT));
        return new Prompt(chars);
    }

    class ForgeConsoleCallback
    implements ConsoleCallback {
        ForgeConsoleCallback() {
        }

        public int readConsoleOutput(ConsoleOutput output) throws IOException {
            CommandLine cl = null;
            if (output.getBuffer() != null && !output.getBuffer().trim().isEmpty()) {
                try {
                    ForgeShell.this.verifyLoadedCommands();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to verify commands.", e);
                }
                for (ShellCommand command : ForgeShell.this.commands) {
                    try {
                        cl = command.parse(output.getBuffer());
                        logger.info("Parsing: " + output.getBuffer() + ", CommandLine is:" + cl);
                        if (cl == null || command.getContext().isStandalone()) continue;
                        try {
                            command.run(output, cl);
                            return 0;
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Command " + command + " failed to run with: " + output, e);
                        }
                    }
                    catch (CommandLineParserException iae) {
                        if (iae instanceof OptionParserException || iae instanceof ArgumentParserException || iae instanceof RequiredOptionException) {
                            ForgeShell.this.console.pushToStdOut(iae.getMessage() + Config.getLineSeparator());
                            logger.info("GOT: " + iae.getMessage() + "\n Parser: " + command.getContext().getParser());
                            return 0;
                        }
                        logger.log(Level.INFO, "Command: " + command + ", did not match: " + output.getBuffer() + "\n" + iae.getMessage());
                    }
                }
                if (cl == null) {
                    ForgeShell.this.console.pushToStdOut(output.getBuffer() + ": command not found." + Config.getLineSeparator());
                }
            }
            return 0;
        }
    }
}

