/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.aesh.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.inject.Inject;
import org.jboss.aesh.util.Parser;
import org.jboss.forge.aesh.ShellContext;
import org.jboss.forge.ui.UICommand;
import org.jboss.forge.ui.context.UIBuilder;
import org.jboss.forge.ui.context.UIContext;
import org.jboss.forge.ui.context.UIValidationContext;
import org.jboss.forge.ui.input.InputComponent;
import org.jboss.forge.ui.input.UICompleter;
import org.jboss.forge.ui.input.UIInput;
import org.jboss.forge.ui.input.UIInputMany;
import org.jboss.forge.ui.metadata.UICommandMetadata;
import org.jboss.forge.ui.result.Result;
import org.jboss.forge.ui.result.Results;
import org.jboss.forge.ui.util.Metadata;

public class LsCommand
implements UICommand {
    @Inject
    private UIInput<String> about;
    @Inject
    private UIInputMany<File> arguments;

    public UICommandMetadata getMetadata() {
        return Metadata.forCommand(this.getClass()).name("ls").description("List files");
    }

    public boolean isEnabled(UIContext context) {
        return context instanceof ShellContext;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Object selection;
        this.about.setLabel("about");
        this.about.setRequired(false);
        this.about.setDefaultValue((Object)"");
        this.about.setCompleter((UICompleter)new UICompleter<String>(){

            public Iterable<String> getCompletionProposals(InputComponent<?, String> input, String value) {
                ArrayList<String> out = new ArrayList<String>();
                out.add("foo1");
                return out;
            }
        });
        builder.add(this.about);
        this.arguments.setLabel("");
        this.arguments.setRequired(false);
        if (builder.getUIContext() instanceof ShellContext && (selection = builder.getUIContext().getInitialSelection().get()) instanceof File) {
            this.arguments.setDefaultValue(Arrays.asList((File)selection));
        }
        builder.add(this.arguments);
    }

    public void validate(UIValidationContext context) {
    }

    public Result execute(UIContext context) throws Exception {
        StringBuilder builder = new StringBuilder();
        if (this.arguments.getValue() != null) {
            Iterator iter = this.arguments.getValue().iterator();
            while (iter.hasNext()) {
                builder.append(((File)iter.next()).getAbsolutePath() + ", ");
            }
        }
        return Results.success((String)this.listMany(this.arguments.getValue(), (ShellContext)context));
    }

    private String listMany(Iterable<File> files, ShellContext context) {
        Iterator iter;
        if (this.arguments.getValue() != null && (iter = this.arguments.getValue().iterator()).hasNext()) {
            return this.listLs((File)iter.next(), context);
        }
        return null;
    }

    private String listLs(File path, ShellContext context) {
        if (path.isDirectory()) {
            ArrayList<String> files = new ArrayList<String>();
            for (File f : path.listFiles()) {
                files.add(f.getName());
            }
            return Parser.formatDisplayList(files, (int)context.getShell().getConsole().getTerminalSize().getHeight(), (int)context.getShell().getConsole().getTerminalSize().getWidth());
        }
        if (path.isFile()) {
            return path.getName();
        }
        return null;
    }
}

