/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.aesh.commands;

import java.net.URL;
import java.util.Arrays;
import javax.inject.Inject;
import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.complete.Completion;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.Console;
import org.jboss.aesh.extensions.manual.Man;
import org.jboss.aesh.util.Parser;
import org.jboss.forge.aesh.ShellContext;
import org.jboss.forge.container.addons.AddonRegistry;
import org.jboss.forge.container.services.ExportedInstance;
import org.jboss.forge.ui.UICommand;
import org.jboss.forge.ui.context.UIBuilder;
import org.jboss.forge.ui.context.UIContext;
import org.jboss.forge.ui.context.UIValidationContext;
import org.jboss.forge.ui.input.UIInputMany;
import org.jboss.forge.ui.metadata.UICommandMetadata;
import org.jboss.forge.ui.result.Result;
import org.jboss.forge.ui.result.Results;
import org.jboss.forge.ui.util.Metadata;

public class ManCommand
implements UICommand,
Completion {
    private AddonRegistry registry;
    @Inject
    private UIInputMany<String> arguments;

    @Inject
    public ManCommand(AddonRegistry registry) {
        this.registry = registry;
    }

    public UICommandMetadata getMetadata() {
        return Metadata.forCommand(this.getClass()).name("man").description("man - an interface to the online reference manuals");
    }

    public boolean isEnabled(UIContext context) {
        return context instanceof ShellContext;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.arguments.setDefaultValue(Arrays.asList(this.getMetadata().getName()));
        this.arguments.setLabel("");
        this.arguments.setRequired(false);
        builder.add(this.arguments);
    }

    public void validate(UIValidationContext validator) {
    }

    public Result execute(UIContext context) throws Exception {
        if (context instanceof ShellContext) {
            Console console = ((ShellContext)context).getShell().getConsole();
            try {
                Man man = new Man(console);
                String commandName = (String)this.arguments.getValue().iterator().next();
                URL docUrl = this.getCommand(commandName);
                if (docUrl != null) {
                    man.setFile(docUrl.openStream(), docUrl.getPath());
                    man.attach(((ShellContext)context).getConsoleOutput());
                } else {
                    console.pushToStdOut("No manual page found for: " + commandName + Config.getLineSeparator());
                }
            }
            catch (Exception ioe) {
                return Results.fail((String)ioe.getMessage());
            }
        }
        return null;
    }

    public void complete(CompleteOperation completeOperation) {
        try {
            if (completeOperation.getBuffer().trim().equals("man")) {
                for (ExportedInstance instance : this.registry.getExportedInstances(UICommand.class)) {
                    completeOperation.addCompletionCandidate(((UICommand)instance.get()).getMetadata().getName());
                }
            } else {
                String item = Parser.findEscapedSpaceWordCloseToEnd((String)completeOperation.getBuffer().trim());
                completeOperation.setOffset(completeOperation.getCursor() - item.length());
                for (ExportedInstance instance : this.registry.getExportedInstances(UICommand.class)) {
                    if (!((UICommand)instance.get()).getMetadata().getName().startsWith(item)) continue;
                    completeOperation.addCompletionCandidate(((UICommand)instance.get()).getMetadata().getName());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private URL getCommand(String name) {
        for (ExportedInstance instance : this.registry.getExportedInstances(UICommand.class)) {
            if (!((UICommand)instance.get()).getMetadata().getName().equals(name)) continue;
            return ((UICommand)instance.get()).getMetadata().getDocLocation();
        }
        return null;
    }
}

