/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.aesh;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.exception.ArgumentParserException;
import org.jboss.aesh.cl.exception.CommandLineParserException;
import org.jboss.aesh.cl.exception.OptionParserException;
import org.jboss.aesh.cl.exception.RequiredOptionException;
import org.jboss.aesh.complete.Completion;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.Console;
import org.jboss.aesh.console.ConsoleCallback;
import org.jboss.aesh.console.ConsoleOutput;
import org.jboss.aesh.console.Prompt;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.terminal.CharacterType;
import org.jboss.aesh.terminal.Color;
import org.jboss.aesh.terminal.TerminalCharacter;
import org.jboss.forge.aesh.ForgeShell;
import org.jboss.forge.aesh.ShellCommand;
import org.jboss.forge.aesh.spi.ShellConfiguration;
import org.jboss.forge.aesh.util.CommandLineUtil;
import org.jboss.forge.aesh.util.UICommandDelegate;
import org.jboss.forge.container.Forge;
import org.jboss.forge.container.addons.Addon;
import org.jboss.forge.container.addons.AddonRegistry;
import org.jboss.forge.container.event.PostStartup;
import org.jboss.forge.container.event.PreShutdown;
import org.jboss.forge.container.services.Exported;
import org.jboss.forge.container.services.ExportedInstance;
import org.jboss.forge.ui.UICommand;
import org.jboss.forge.ui.context.UIContext;
import org.jboss.forge.ui.result.NavigationResult;
import org.jboss.forge.ui.result.Result;
import org.jboss.forge.ui.wizard.UIWizard;

@Singleton
@Exported
public class ForgeShellImpl
implements ForgeShell {
    private static final Logger logger = Logger.getLogger(ForgeShellImpl.class.getName());
    private Console console;
    private Prompt prompt;
    private List<ShellCommand> wizardSteps = new ArrayList<ShellCommand>();
    private List<ShellCommand> commands;
    @Inject
    private Forge forge;
    @Inject
    private Addon self;
    @Inject
    private AddonRegistry registry;

    void observe(@Observes PostStartup startup) throws Exception {
        this.startShell();
    }

    void stop(@Observes PreShutdown shutdown) throws Exception {
        if (this.console != null && this.console.isRunning()) {
            this.console.stop();
        }
    }

    public void addCommand(ShellCommand command) {
        this.commands.add(command);
        this.console.addCompletion((Completion)command);
    }

    private void initShell() throws Exception {
        this.prompt = this.createPrompt();
        Settings.getInstance().setReadInputrc(false);
        Settings.getInstance().setLogging(true);
        for (ExportedInstance instance : this.registry.getExportedInstances(ShellConfiguration.class)) {
            ShellConfiguration provider = (ShellConfiguration)instance.get();
            provider.configure();
        }
        this.commands = new ArrayList<ShellCommand>();
        this.console = Console.getInstance();
        this.console.setPrompt(this.prompt);
        this.console.setConsoleCallback((ConsoleCallback)new ForgeConsoleCallback());
        this.refreshAvailableCommands();
    }

    private void refreshAvailableCommands() {
        Set instances = this.registry.getExportedInstances(UICommand.class);
        HashSet<UICommand> loaded = new HashSet<UICommand>();
        for (ExportedInstance instance : instances) {
            UICommand command = (UICommand)instance.get();
            loaded.add(command);
            if (this.isCommandLoaded(command)) continue;
            try {
                this.addCommand(new ShellCommand(this.registry, this, command));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to load command [" + instance + "]");
            }
        }
        Iterator<ShellCommand> iterable = this.commands.iterator();
        HashSet<ShellCommand> toRemove = new HashSet<ShellCommand>();
        while (iterable.hasNext()) {
            ShellCommand next = iterable.next();
            if (this.isCommandAvailable(loaded, next.getCommand().getMetadata().getName())) continue;
            toRemove.add(next);
        }
        this.commands.removeAll(toRemove);
    }

    private boolean isCommandLoaded(UICommand uiCommand) {
        for (ShellCommand command : this.commands) {
            if (!command.getCommand().getMetadata().getName().equals(new UICommandDelegate(uiCommand).getMetadata().getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isCommandAvailable(Set<UICommand> availableCommands, String name) {
        for (UICommand command : availableCommands) {
            if (!new UICommandDelegate(command).getMetadata().getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void startShell() throws Exception {
        this.initShell();
        this.console.start();
    }

    public AddonRegistry getRegistry() {
        return this.registry;
    }

    public String getPrompt() {
        return this.prompt.getPromptAsString();
    }

    public Console getConsole() {
        return this.console;
    }

    public void stopShell() throws IOException {
        if (this.console != null && this.console.isRunning()) {
            this.console.stop();
            this.console.reset();
        }
    }

    private Prompt createPrompt() {
        ArrayList<TerminalCharacter> chars = new ArrayList<TerminalCharacter>();
        chars.add(new TerminalCharacter('[', Color.DEFAULT_BG, Color.BLUE_TEXT));
        chars.add(new TerminalCharacter('f', Color.DEFAULT_BG, Color.RED_TEXT, CharacterType.BOLD));
        chars.add(new TerminalCharacter('o', Color.DEFAULT_BG, Color.RED_TEXT, CharacterType.BOLD));
        chars.add(new TerminalCharacter('r', Color.DEFAULT_BG, Color.RED_TEXT, CharacterType.BOLD));
        chars.add(new TerminalCharacter('g', Color.DEFAULT_BG, Color.RED_TEXT, CharacterType.BOLD));
        chars.add(new TerminalCharacter('e', Color.DEFAULT_BG, Color.RED_TEXT, CharacterType.BOLD));
        chars.add(new TerminalCharacter(']', Color.DEFAULT_BG, Color.BLUE_TEXT, CharacterType.PLAIN));
        chars.add(new TerminalCharacter('$', Color.DEFAULT_BG, Color.DEFAULT_TEXT));
        chars.add(new TerminalCharacter(' ', Color.DEFAULT_BG, Color.DEFAULT_TEXT));
        return new Prompt(chars);
    }

    private ForgeShell getForgeShell() {
        return this;
    }

    class ForgeConsoleCallback
    implements ConsoleCallback {
        ForgeConsoleCallback() {
        }

        public int readConsoleOutput(ConsoleOutput output) throws IOException {
            ForgeShellImpl.this.refreshAvailableCommands();
            if (output.getBuffer() != null && !output.getBuffer().trim().isEmpty()) {
                if (ForgeShellImpl.this.wizardSteps.size() == 0) {
                    return this.parseUICommand(output);
                }
                return this.parseWizardStep(output);
            }
            return -1;
        }

        private int parseWizardStep(ConsoleOutput output) throws IOException {
            block4: {
                ShellCommand currentCommand = (ShellCommand)ForgeShellImpl.this.wizardSteps.get(ForgeShellImpl.this.wizardSteps.size() - 1);
                try {
                    CommandLine cl = currentCommand.parse(output.getBuffer());
                    if (cl == null) break block4;
                    CommandLineUtil.populateUIInputs(cl, currentCommand.getContext(), ForgeShellImpl.this.registry);
                    currentCommand.getContext().setConsoleOutput(output);
                    UIWizard wizard = (UIWizard)((ShellCommand)ForgeShellImpl.this.wizardSteps.get(0)).getCommand();
                    NavigationResult navResult = wizard.next((UIContext)((ShellCommand)ForgeShellImpl.this.wizardSteps.get(0)).getContext());
                    if (navResult != null) {
                        Class cmd = navResult.getNext();
                        ForgeShellImpl.this.wizardSteps.add(new ShellCommand(ForgeShellImpl.this.registry, ForgeShellImpl.this.getForgeShell(), (UICommand)cmd));
                        break block4;
                    }
                    return this.executeWizardSteps();
                }
                catch (CommandLineParserException e) {
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return 0;
        }

        private int executeWizardSteps() throws IOException {
            for (ShellCommand command : ForgeShellImpl.this.wizardSteps) {
                try {
                    Result result = command.getCommand().execute((UIContext)command.getContext());
                    if (result == null || result.getMessage() == null || result.getMessage().length() <= 0) continue;
                    ForgeShellImpl.this.getConsole().pushToStdOut(result.getMessage() + Config.getLineSeparator());
                }
                catch (Exception exception) {}
            }
            ForgeShellImpl.this.wizardSteps.clear();
            return 1;
        }

        private int parseUICommand(ConsoleOutput output) throws IOException {
            int result = 1;
            CommandLine cl = null;
            for (ShellCommand command : ForgeShellImpl.this.commands) {
                try {
                    cl = command.parse(output.getBuffer());
                    logger.info("Parsing: " + output.getBuffer() + ", CommandLine is:" + cl);
                    if (cl == null) continue;
                    if (command.getCommand() instanceof UIWizard) {
                        ForgeShellImpl.this.wizardSteps.add(command);
                        return this.parseWizardStep(output);
                    }
                    try {
                        command.run(output, cl);
                        result = 0;
                        break;
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Command " + command + " failed to run with: " + output, e);
                        result = 1;
                    }
                }
                catch (CommandLineParserException iae) {
                    if (iae instanceof OptionParserException || iae instanceof ArgumentParserException || iae instanceof RequiredOptionException) {
                        ForgeShellImpl.this.console.pushToStdOut(iae.getMessage() + Config.getLineSeparator());
                        logger.info("GOT: " + iae.getMessage() + "\n Parser: " + command.getContext().getParser());
                        result = 1;
                        break;
                    }
                    logger.log(Level.INFO, "Command: " + command + ", did not match: " + output.getBuffer() + "\n" + iae.getMessage());
                }
            }
            if (cl == null) {
                ForgeShellImpl.this.console.pushToStdOut(output.getBuffer() + ": command not found." + Config.getLineSeparator());
            }
            return result;
        }
    }
}

