/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.aesh.util;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.CommandLineParser;
import org.jboss.aesh.cl.OptionBuilder;
import org.jboss.aesh.cl.ParserBuilder;
import org.jboss.aesh.cl.exception.OptionParserException;
import org.jboss.aesh.cl.internal.ParameterInt;
import org.jboss.forge.aesh.ShellContext;
import org.jboss.forge.container.addons.AddonRegistry;
import org.jboss.forge.convert.Converter;
import org.jboss.forge.convert.ConverterFactory;
import org.jboss.forge.ui.UICommand;
import org.jboss.forge.ui.input.InputComponent;
import org.jboss.forge.ui.input.UIInput;
import org.jboss.forge.ui.input.UIInputMany;
import org.jboss.forge.ui.input.UISelectMany;
import org.jboss.forge.ui.input.UISelectOne;
import org.jboss.forge.ui.util.InputComponents;

public class CommandLineUtil {
    private static final Logger logger = Logger.getLogger(CommandLineUtil.class.getName());
    private static ConverterFactory converterFactory = null;

    public static CommandLineParser generateParser(UICommand command, ShellContext context) {
        ParserBuilder builder = new ParserBuilder();
        ParameterInt parameter = new ParameterInt(command.getMetadata().getName(), command.getMetadata().getDescription());
        for (InputComponent input : context.getInputs()) {
            if (input.getName().equals("arguments")) continue;
            try {
                if (input.getValueType() == Boolean.class) {
                    parameter.addOption(new OptionBuilder().longName(input.getName()).hasValue(false).description(input.getLabel()).create());
                    continue;
                }
                parameter.addOption(new OptionBuilder().longName(input.getName()).description(input.getLabel()).required(input.isRequired()).create());
            }
            catch (OptionParserException e) {}
        }
        builder.addParameter(parameter);
        return builder.generateParser();
    }

    public static void populateUIInputs(CommandLine commandLine, ShellContext context, AddonRegistry registry) {
        for (InputComponent input : context.getInputs()) {
            if (input.getName().equals("arguments") && input instanceof UIInputMany) {
                CommandLineUtil.setInput(input, commandLine.getArguments(), registry);
                continue;
            }
            if (input instanceof UIInputMany) {
                CommandLineUtil.setInput(input, commandLine.getOptionValues(input.getName()), registry);
                continue;
            }
            if (input instanceof UIInput) {
                CommandLineUtil.setInput(input, commandLine.getOptionValue(input.getName()), registry);
                continue;
            }
            if (input instanceof UISelectMany) {
                CommandLineUtil.setInputChoices((UISelectMany<Object>)((UISelectMany)input), commandLine.getOptionValues(input.getName()), registry);
                continue;
            }
            if (!(input instanceof UISelectOne)) continue;
            CommandLineUtil.setInputChoice((UISelectOne<Object>)((UISelectOne)input), commandLine.getOptionValue(input.getName()), registry);
        }
    }

    private static void setInputChoice(UISelectOne<Object> input, String optionValue, AddonRegistry registry) {
        Converter labelConverter = input.getItemLabelConverter();
        boolean found = false;
        for (Object choice : input.getValueChoices()) {
            if (!((String)labelConverter.convert(choice)).equals(optionValue)) continue;
            input.setValue(choice);
            found = true;
            break;
        }
        if (!found) {
            logger.warning("Could not find matching value choice for input value [" + optionValue + "]");
        }
    }

    private static void setInputChoices(UISelectMany<Object> input, List<String> optionValues, AddonRegistry registry) {
        Converter labelConverter = input.getItemLabelConverter();
        ArrayList selected = new ArrayList();
        for (String optionValue : optionValues) {
            boolean found = false;
            for (Object choice : input.getValueChoices()) {
                if (!((String)labelConverter.convert(choice)).equals(optionValue)) continue;
                selected.add(choice);
                found = true;
                break;
            }
            if (found) continue;
            logger.warning("Could not find matching value choice for input value [" + optionValue + "]");
        }
        input.setValue(selected);
    }

    public static void setInput(InputComponent<?, Object> input, Object value, AddonRegistry registry) {
        if (converterFactory == null) {
            converterFactory = (ConverterFactory)registry.getExportedInstance(ConverterFactory.class).get();
        }
        InputComponents.setValueFor((ConverterFactory)converterFactory, input, (Object)value);
    }
}

