/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.aesh.util;

import java.net.URL;
import javax.enterprise.inject.Vetoed;
import org.jboss.forge.ui.UICommand;
import org.jboss.forge.ui.context.UIBuilder;
import org.jboss.forge.ui.context.UIContext;
import org.jboss.forge.ui.context.UIValidationContext;
import org.jboss.forge.ui.metadata.UICategory;
import org.jboss.forge.ui.metadata.UICommandMetadata;
import org.jboss.forge.ui.result.Result;

@Vetoed
public class UICommandDelegate
implements UICommand {
    private UICommand delegate;

    public UICommandDelegate(UICommand delegate) {
        this.delegate = delegate;
    }

    public UICommandMetadata getMetadata() {
        if (this.delegate.getMetadata().getName().contains(" ")) {
            return new UICommandMetadataImpl(this.shellifyName(this.delegate.getMetadata().getName()), this.delegate.getMetadata().getDescription(), this.delegate.getMetadata().getCategory(), this.delegate.getMetadata().getDocLocation());
        }
        return this.delegate.getMetadata();
    }

    public boolean isEnabled(UIContext context) {
        return this.delegate.isEnabled(context);
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.delegate.initializeUI(builder);
    }

    public void validate(UIValidationContext validator) {
        this.delegate.validate(validator);
    }

    public Result execute(UIContext context) throws Exception {
        return this.delegate.execute(context);
    }

    private String shellifyName(String name) {
        return name.trim().toLowerCase().replaceAll("\\W+", "-");
    }

    class UICommandMetadataImpl
    implements UICommandMetadata {
        private String name;
        private String desc;
        private UICategory category;
        private URL loc;

        public UICommandMetadataImpl(String name, String desc, UICategory category, URL loc) {
            this.name = name;
            this.desc = desc;
            this.category = category;
            this.loc = loc;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.desc;
        }

        public UICategory getCategory() {
            return this.category;
        }

        public URL getDocLocation() {
            return this.loc;
        }

        public String toString() {
            return super.toString();
        }
    }
}

