/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.convert.impl;

import java.lang.reflect.Method;
import javax.enterprise.inject.Vetoed;
import org.jboss.forge.convert.AbstractConverter;
import org.jboss.forge.convert.exception.ConversionException;

@Vetoed
public class MethodConverter<S, T>
extends AbstractConverter<S, T> {
    private final Object instance;
    private final Method method;

    public MethodConverter(Class<S> sourceType, Class<T> targetType, Object instance, Method method) {
        super(sourceType, targetType);
        this.instance = instance;
        this.method = method;
    }

    public T convert(S source) {
        try {
            return (T)this.method.invoke(this.instance, source);
        }
        catch (Exception e) {
            throw new ConversionException("Could not convert [" + source + "] to type [" + this.getTargetType() + "]", (Throwable)e);
        }
    }
}

