/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.convert.impl;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.container.addons.AddonRegistry;
import org.jboss.forge.container.services.Exported;
import org.jboss.forge.container.services.ExportedInstance;
import org.jboss.forge.convert.Converter;
import org.jboss.forge.convert.ConverterFactory;
import org.jboss.forge.convert.ConverterGenerator;
import org.jboss.forge.convert.exception.ConverterNotFoundException;
import org.jboss.forge.convert.impl.ConstructorConverter;
import org.jboss.forge.convert.impl.Converters;
import org.jboss.forge.convert.impl.MethodConverter;

@Exported
@Singleton
public class ConverterFactoryImpl
implements ConverterFactory {
    @Inject
    private AddonRegistry registry;

    public <S, T> Converter<S, T> getConverter(Class<S> source, Class<T> target) {
        Object result = null;
        for (ExportedInstance generatorInstance : this.registry.getExportedInstances(ConverterGenerator.class)) {
            ConverterGenerator generator = (ConverterGenerator)generatorInstance.get();
            if (!generator.handles(source, target)) continue;
            result = generator.generateConverter(source, target);
            break;
        }
        if (result == null) {
            if (String.class.equals(target)) {
                result = Converters.TO_STRING;
            } else if (target.isAssignableFrom(source)) {
                result = Converters.NOOP;
            } else {
                try {
                    result = new MethodConverter<S, T>(source, target, null, target.getMethod("valueOf", source));
                }
                catch (NoSuchMethodException noValueOf) {
                    try {
                        result = new ConstructorConverter<S, T>(source, target, target.getConstructor(source));
                    }
                    catch (NoSuchMethodException noConstructor) {
                        throw new ConverterNotFoundException(source, target);
                    }
                }
            }
        }
        return result;
    }
}

