/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.dependencies.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.forge.container.util.Predicate;
import org.jboss.forge.dependencies.Coordinate;
import org.jboss.forge.dependencies.Dependency;
import org.jboss.forge.dependencies.DependencyQuery;
import org.jboss.forge.dependencies.DependencyRepository;
import org.jboss.forge.dependencies.builder.CoordinateBuilder;

public class DependencyQueryBuilder
implements DependencyQuery {
    private Coordinate coordinate;
    private String scopeType;
    private Predicate<Dependency> dependencyFilter;
    private List<DependencyRepository> dependencyRepositories = new ArrayList<DependencyRepository>();

    protected DependencyQueryBuilder() {
    }

    private DependencyQueryBuilder(Coordinate coordinate) {
        this.setCoordinate(coordinate);
    }

    public static DependencyQueryBuilder create(String coordinate) {
        return new DependencyQueryBuilder(CoordinateBuilder.create(coordinate));
    }

    public static DependencyQueryBuilder create(Coordinate coordinate) {
        return new DependencyQueryBuilder(coordinate);
    }

    public static DependencyQueryBuilder create(DependencyQuery query) {
        DependencyQueryBuilder builder = new DependencyQueryBuilder();
        builder.setCoordinate(query.getCoordinate());
        builder.setFilter(query.getDependencyFilter());
        builder.setRepositories(query.getDependencyRepositories());
        builder.setScopeType(query.getScopeType());
        return builder;
    }

    private void setCoordinate(Coordinate coordinate) {
        if (coordinate == null) {
            throw new IllegalArgumentException("Coordinate must be set");
        }
        this.coordinate = coordinate;
    }

    public DependencyQueryBuilder setFilter(Predicate<Dependency> dependencyFilter) {
        this.dependencyFilter = dependencyFilter;
        return this;
    }

    public DependencyQueryBuilder setRepositories(DependencyRepository ... dependencyRepositories) {
        return this.setRepositories(Arrays.asList(dependencyRepositories));
    }

    public DependencyQueryBuilder setRepositories(Iterable<DependencyRepository> dependencyRepositories) {
        if (dependencyRepositories != null) {
            for (DependencyRepository dependencyRepository : dependencyRepositories) {
                this.dependencyRepositories.add(dependencyRepository);
            }
        }
        return this;
    }

    public DependencyQueryBuilder setScopeType(String scopeType) {
        this.scopeType = scopeType;
        return this;
    }

    @Override
    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    @Override
    public Predicate<Dependency> getDependencyFilter() {
        return this.dependencyFilter;
    }

    @Override
    public List<DependencyRepository> getDependencyRepositories() {
        return this.dependencyRepositories;
    }

    @Override
    public String getScopeType() {
        return this.scopeType;
    }

    public String toString() {
        return this.coordinate.toString() + " - " + this.scopeType;
    }
}

