/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.facets;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.forge.facets.Facet;
import org.jboss.forge.facets.FacetNotFoundException;
import org.jboss.forge.facets.Faceted;

public abstract class AbstractFaceted<FACETTYPE extends Facet<?>>
implements Faceted<FACETTYPE> {
    private Set<FACETTYPE> facets = Collections.newSetFromMap(new ConcurrentHashMap());

    @Override
    public boolean hasFacet(Class<? extends FACETTYPE> type) {
        try {
            this.getFacet(type);
            return true;
        }
        catch (FacetNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean hasAllFacets(Iterable<Class<? extends FACETTYPE>> iterable) {
        for (Class<FACETTYPE> clazz : iterable) {
            if (this.hasFacet(clazz)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasAllFacets(Class<? extends FACETTYPE> ... types) {
        for (Class<FACETTYPE> clazz : types) {
            if (this.hasFacet(clazz)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <F extends FACETTYPE> F getFacet(Class<F> type) throws FacetNotFoundException {
        for (Facet facet : this.facets) {
            if (!type.isAssignableFrom(facet.getClass())) continue;
            return (F)facet;
        }
        throw new FacetNotFoundException("No Facet of type [" + type + "] is installed.");
    }

    @Override
    public Iterable<FACETTYPE> getFacets() {
        return Collections.unmodifiableCollection(this.facets);
    }

    @Override
    public <F extends FACETTYPE> Iterable<F> getFacets(Class<F> type) {
        HashSet<Facet> result = new HashSet<Facet>();
        for (Facet facet : this.facets) {
            if (!type.isAssignableFrom(facet.getClass())) continue;
            result.add(facet);
        }
        return result;
    }

    @Override
    public boolean install(FACETTYPE facet) {
        if (facet.getOrigin() != this) {
            throw new IllegalArgumentException("[" + facet + "].getOrigin() was [" + facet.getOrigin() + "] but needed to be [" + this + "].");
        }
        if (this.supports(facet) && (facet.isInstalled() || facet.install())) {
            this.facets.add(facet);
            return true;
        }
        return false;
    }

    @Override
    public boolean uninstall(FACETTYPE facet) {
        if (facet.isInstalled()) {
            return facet.uninstall();
        }
        return true;
    }
}

