/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.parser.java.util.Strings;

public class Refactory {
    public static void createGetterAndSetter(JavaClass clazz, Field<JavaClass> field) {
        if (!clazz.hasField(field)) {
            throw new IllegalArgumentException("Entity did not contain the given field [" + field + "]");
        }
        clazz.getMethods();
        String fieldName = field.getName();
        String methodNameSuffix = Strings.capitalize(fieldName);
        ((Method)((Method)clazz.addMethod().setReturnType(field.getTypeInspector().toString()).setName("get" + methodNameSuffix)).setPublic()).setBody("return this." + fieldName + ";");
        if (!field.isFinal()) {
            ((Method)((Method)clazz.addMethod().setReturnTypeVoid().setName("set" + methodNameSuffix)).setPublic()).setParameters("final " + field.getTypeInspector().toString() + " " + fieldName).setBody("this." + fieldName + " = " + fieldName + ";");
        }
    }

    @Deprecated
    public static void createHashCodeAndEquals(JavaClass clazz) {
        clazz.addMethod("public boolean equals(Object that) { if (this == that) { return true; } if (that == null) { return false; } if (getClass() != that.getClass()) { return false; } if (id != null) { return id.equals(((" + clazz.getName() + ") that).id); } " + "return super.equals(that); " + "}").addAnnotation(Override.class);
        clazz.addMethod("public int hashCode() { if (id != null) { return id.hashCode(); } return super.hashCode(); }").addAnnotation(Override.class);
    }

    public static void createHashCodeAndEquals(JavaClass clazz, Field<?> ... fields) {
        if (clazz == null) {
            throw new IllegalArgumentException("The provided class cannot be null.");
        }
        if (fields == null || fields.length < 1) {
            throw new IllegalArgumentException("The provided fields cannot be null or empty.");
        }
        String superEqualsCheck = "";
        String defaultHashcode = "int result = 1;";
        if (!clazz.getSuperType().equals("java.lang.Object")) {
            superEqualsCheck = "if (!super.equals(obj)) { return false;} ";
            defaultHashcode = "int result = super.hashCode();";
        }
        boolean isTempFieldCreated = false;
        StringBuilder fieldEqualityChecks = new StringBuilder();
        StringBuilder hashCodeComputation = new StringBuilder();
        for (Field<?> field : fields) {
            if (field == null) {
                throw new IllegalArgumentException("A supplied field was null. The equals and hashCode computation will be aborted.");
            }
            if (field.isStatic()) {
                throw new IllegalArgumentException("A static field was detected. The equals and hashCode computation will be aborted.");
            }
            String fieldName = field.getName();
            if (field.isPrimitive()) {
                if (field.isType("float")) {
                    fieldEqualityChecks.append("if (Float.floatToIntBits(").append(fieldName).append(") != Float.floatToIntBits(other.").append(fieldName).append(")) { ");
                    fieldEqualityChecks.append(" return false;");
                    fieldEqualityChecks.append("} ");
                    hashCodeComputation.append("result = prime * result + ").append("Float.floatToIntBits(").append(fieldName).append(");");
                    continue;
                }
                if (field.isType("double")) {
                    fieldEqualityChecks.append("if (Double.doubleToLongBits(").append(fieldName).append(") != Double.doubleToLongBits(other.").append(fieldName).append(")) { ");
                    fieldEqualityChecks.append(" return false;");
                    fieldEqualityChecks.append("} ");
                    if (!isTempFieldCreated) {
                        hashCodeComputation.append("long temp;");
                        isTempFieldCreated = true;
                    }
                    hashCodeComputation.append("temp = Double.doubleToLongBits(").append(fieldName).append(");");
                    hashCodeComputation.append("result = prime * result + (int) (temp ^ (temp >>> 32));");
                    continue;
                }
                fieldEqualityChecks.append("if (").append(fieldName).append(" != other.").append(fieldName).append(") { ");
                fieldEqualityChecks.append(" return false;");
                fieldEqualityChecks.append("} ");
                if (field.isType("long")) {
                    hashCodeComputation.append("result = prime * result + (int) (").append(fieldName).append(" ^ (").append(fieldName).append(" >>> 32));");
                    continue;
                }
                if (field.isType("boolean")) {
                    hashCodeComputation.append("result = prime * result + (").append(fieldName).append(" ? 1231 : 1237);");
                    continue;
                }
                hashCodeComputation.append("result = prime * result + ").append(fieldName).append(";");
                continue;
            }
            if (field.getTypeInspector().isArray()) {
                fieldEqualityChecks.append("if (!Arrays.equals(").append(fieldName).append(", other.").append(fieldName).append(")) {");
                fieldEqualityChecks.append(" return false; }");
                hashCodeComputation.append("result = prime * result + Arrays.hashCode(").append(fieldName).append(");");
                continue;
            }
            fieldEqualityChecks.append("if (").append(fieldName).append(" != null) { ");
            fieldEqualityChecks.append(" if(!").append(fieldName).append(".equals(");
            fieldEqualityChecks.append("other.").append(fieldName);
            fieldEqualityChecks.append(")) { return false;} } ");
            hashCodeComputation.append("result = prime * result + ((").append(fieldName).append(" == null) ? 0 : ").append(fieldName).append(".hashCode());");
        }
        if (fieldEqualityChecks.length() < 1 || hashCodeComputation.length() < 1) {
            throw new IllegalArgumentException("A failure was detected when generating the equals and hashCode methods. Verify the type and modifiers of the provided fields.");
        }
        StringBuilder typeCheckAndAssignment = new StringBuilder();
        String klassName = clazz.getName();
        typeCheckAndAssignment.append("if (!(obj instanceof ").append(klassName).append(")) {");
        typeCheckAndAssignment.append(" return false;}");
        typeCheckAndAssignment.append(klassName).append(" other = (").append(klassName).append(") obj;");
        clazz.addMethod("public boolean equals(Object obj) { if (this == obj) { return true; } " + superEqualsCheck.toString() + typeCheckAndAssignment.toString() + fieldEqualityChecks.toString() + "return true; " + "}").addAnnotation(Override.class);
        clazz.addMethod("public int hashCode() { final int prime = 31;" + defaultHashcode + hashCodeComputation.toString() + "return result; }").addAnnotation(Override.class);
    }

    public static void createToStringFromFields(JavaClass clazz) {
        List<Field<JavaClass>> fields = clazz.getFields();
        Refactory.createToStringFromFields(clazz, fields);
    }

    public static void createToStringFromFields(JavaClass clazz, Field<JavaClass> ... fields) {
        Refactory.createToStringFromFields(clazz, Arrays.asList(fields));
    }

    public static void createToStringFromFields(JavaClass clazz, List<Field<JavaClass>> fields) {
        Method method = (Method)((Method)clazz.addMethod().setName("toString")).setReturnType(String.class).setPublic();
        method.addAnnotation(Override.class);
        ArrayList<String> list = new ArrayList<String>();
        String delimeter = "\n";
        for (Field<JavaClass> field : fields) {
            if (!clazz.hasField(field)) continue;
            StringBuilder line = new StringBuilder();
            if (!field.isPrimitive()) {
                if (field.isType(String.class)) {
                    line.append("if(").append(field.getName()).append(" != null && !").append(field.getName()).append(".trim().isEmpty())\n");
                } else {
                    line.append("if(").append(field.getName()).append(" != null)\n");
                }
            }
            boolean isFirst = list.isEmpty();
            line.append(" result += ").append(isFirst ? "\"" : "\", ");
            line.append(field.getName()).append(": \" + ").append(field.getName()).append(";");
            list.add(line.toString());
        }
        String body = "String result = getClass().getSimpleName()+\" \";\n" + Strings.join(list, delimeter) + "\n" + "return result;";
        method.setBody(body);
    }
}

