/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jface.text.Document;
import org.jboss.forge.parser.java.AnnotationElement;
import org.jboss.forge.parser.java.JavaAnnotation;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.SourceType;
import org.jboss.forge.parser.java.impl.AbstractJavaSource;
import org.jboss.forge.parser.java.impl.AnnotationElementImpl;
import org.jboss.forge.parser.java.util.Strings;

public class JavaAnnotationImpl
extends AbstractJavaSource<JavaAnnotation>
implements JavaAnnotation {
    public JavaAnnotationImpl(JavaSource<?> enclosingType, Document document, CompilationUnit unit, BodyDeclaration body) {
        super(enclosingType, document, unit, body);
    }

    @Override
    protected JavaAnnotation updateTypeNames(String name) {
        return this;
    }

    public SourceType getSourceType() {
        return SourceType.ANNOTATION;
    }

    public AnnotationElement addAnnotationElement() {
        return this.add(new AnnotationElementImpl(this));
    }

    public AnnotationElement addAnnotationElement(String declaration) {
        return this.add(new AnnotationElementImpl((JavaAnnotation)this, declaration));
    }

    private AnnotationElement add(AnnotationElement annotationElement) {
        ListIterator<BodyDeclaration> members = this.getBodyDeclaration().bodyDeclarations().listIterator();
        while (members.hasNext() && !(members.next() instanceof AnnotationTypeMemberDeclaration)) {
        }
        while (members.hasNext()) {
            if (members.next() instanceof AnnotationTypeMemberDeclaration) continue;
            members.previous();
            break;
        }
        members.add((BodyDeclaration)annotationElement.getInternal());
        return annotationElement;
    }

    public boolean hasAnnotationElement(String name) {
        for (AnnotationElement annotationElement : this.getAnnotationElements()) {
            if (!Strings.areEqual((String)name, (String)annotationElement.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnnotationElement(AnnotationElement annotationElement) {
        return this.getAnnotationElements().contains(annotationElement);
    }

    public AnnotationElement getAnnotationElement(String name) {
        for (AnnotationElement annotationElement : this.getAnnotationElements()) {
            if (!Strings.areEqual((String)name, (String)annotationElement.getName())) continue;
            return annotationElement;
        }
        return null;
    }

    public List<AnnotationElement> getAnnotationElements() {
        ArrayList<AnnotationElementImpl> result = new ArrayList<AnnotationElementImpl>();
        List bodyDeclarations = this.getBodyDeclaration().bodyDeclarations();
        for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            if (!(bodyDeclaration instanceof AnnotationTypeMemberDeclaration)) continue;
            result.add(new AnnotationElementImpl((JavaAnnotation)this, bodyDeclaration));
        }
        return Collections.unmodifiableList(result);
    }

    public JavaAnnotation removeAnnotationElement(AnnotationElement annotationElement) {
        this.getBodyDeclaration().bodyDeclarations().remove(annotationElement.getInternal());
        return this;
    }
}

