/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.Annotation;
import org.jboss.forge.parser.java.JavaType;
import org.jboss.forge.parser.java.Type;
import org.jboss.forge.parser.java.ast.AnnotationAccessor;
import org.jboss.forge.parser.java.impl.AnnotationImpl;
import org.jboss.forge.parser.java.impl.TypeImpl;
import org.jboss.forge.parser.java.source.AnnotationElementSource;
import org.jboss.forge.parser.java.source.AnnotationSource;
import org.jboss.forge.parser.java.source.AnnotationTargetSource;
import org.jboss.forge.parser.java.source.JavaAnnotationSource;
import org.jboss.forge.parser.java.util.Assert;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.parser.java.util.Types;

public class AnnotationElementImpl
implements AnnotationElementSource {
    private final AnnotationAccessor<JavaAnnotationSource, AnnotationElementSource> annotations = new AnnotationAccessor();
    private JavaAnnotationSource parent;
    private AST ast;
    private final AnnotationTypeMemberDeclaration member;

    public AnnotationElementImpl(JavaAnnotationSource parent) {
        this(parent, ((ASTNode)parent.getInternal()).getAST().newAnnotationTypeMemberDeclaration());
    }

    public AnnotationElementImpl(JavaAnnotationSource parent, String declaration) {
        this(parent, AnnotationElementImpl.parseElement(parent, declaration));
    }

    public AnnotationElementImpl(JavaAnnotationSource parent, Object internal) {
        this.parent = parent;
        this.ast = ((ASTNode)parent.getInternal()).getAST();
        this.member = (AnnotationTypeMemberDeclaration)internal;
    }

    private static AnnotationTypeMemberDeclaration parseElement(JavaAnnotationSource parent, String declaration) {
        if (!declaration.trim().endsWith(";")) {
            declaration = declaration + ";";
        }
        String stub = "public @interface Stub { " + declaration + " }";
        JavaAnnotationSource temp = (JavaAnnotationSource)JavaParser.parse((String)stub);
        List fields = temp.getAnnotationElements();
        AnnotationTypeMemberDeclaration newField = (AnnotationTypeMemberDeclaration)((AnnotationElementSource)fields.get(0)).getInternal();
        return (AnnotationTypeMemberDeclaration)ASTNode.copySubtree((AST)((ASTNode)parent.getInternal()).getAST(), (ASTNode)newField);
    }

    public JavaAnnotationSource getOrigin() {
        return (JavaAnnotationSource)this.parent.getOrigin();
    }

    public Object getInternal() {
        return this.member;
    }

    public AnnotationSource<JavaAnnotationSource> addAnnotation() {
        return this.annotations.addAnnotation((AnnotationTargetSource<JavaAnnotationSource, AnnotationElementSource>)this, (ASTNode)this.member);
    }

    public AnnotationSource<JavaAnnotationSource> addAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        if (this.parent.requiresImport(clazz)) {
            this.parent.addImport(clazz);
        }
        return this.annotations.addAnnotation((AnnotationTargetSource<JavaAnnotationSource, AnnotationElementSource>)this, (ASTNode)this.member, clazz.getSimpleName());
    }

    public AnnotationSource<JavaAnnotationSource> addAnnotation(String className) {
        return this.annotations.addAnnotation((AnnotationTargetSource<JavaAnnotationSource, AnnotationElementSource>)this, (ASTNode)this.member, className);
    }

    public List<AnnotationSource<JavaAnnotationSource>> getAnnotations() {
        return this.annotations.getAnnotations((AnnotationTargetSource<JavaAnnotationSource, AnnotationElementSource>)this, (ASTNode)this.member);
    }

    public boolean hasAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.hasAnnotation(this, (ASTNode)this.member, type.getName());
    }

    public boolean hasAnnotation(String type) {
        return this.annotations.hasAnnotation(this, (ASTNode)this.member, type);
    }

    public AnnotationSource<JavaAnnotationSource> getAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.getAnnotation((AnnotationTargetSource<JavaAnnotationSource, AnnotationElementSource>)this, (ASTNode)this.member, type);
    }

    public AnnotationSource<JavaAnnotationSource> getAnnotation(String type) {
        return this.annotations.getAnnotation((AnnotationTargetSource<JavaAnnotationSource, AnnotationElementSource>)this, (ASTNode)this.member, type);
    }

    public AnnotationElementSource removeAnnotation(Annotation<JavaAnnotationSource> annotation) {
        return this.annotations.removeAnnotation(this, (ASTNode)this.member, annotation);
    }

    public String toString() {
        return this.member.toString();
    }

    public String getName() {
        return this.member.getName().toString();
    }

    public AnnotationElementSource setName(String name) {
        this.member.setName(this.ast.newSimpleName(name));
        return this;
    }

    public String getType() {
        return Types.toSimpleName((String)this.getQualifiedType());
    }

    public String getQualifiedType() {
        Object type = this.member.getStructuralProperty((StructuralPropertyDescriptor)AnnotationTypeMemberDeclaration.TYPE_PROPERTY);
        return this.parent.resolveType(type.toString());
    }

    public Type<JavaAnnotationSource> getTypeInspector() {
        return new TypeImpl<JavaAnnotationSource>(this.parent, this.member.getStructuralProperty((StructuralPropertyDescriptor)AnnotationTypeMemberDeclaration.TYPE_PROPERTY));
    }

    public boolean isType(Class<?> type) {
        if (Strings.areEqual((String)type.getName(), (String)this.getQualifiedType())) {
            return true;
        }
        if (this.getTypeInspector().isPrimitive() && type.getSimpleName().equals(this.getType())) {
            return true;
        }
        String simpleName = type.getSimpleName();
        return Strings.areEqual((String)simpleName, (String)this.getQualifiedType()) && (this.getOrigin().hasImport(type) || !this.getOrigin().requiresImport(type));
    }

    public boolean isType(String name) {
        if (Strings.areEqual((String)name, (String)this.getQualifiedType())) {
            return true;
        }
        return (!Types.isQualified((String)name) || this.getOrigin().hasImport(name) || !this.getOrigin().requiresImport(name)) && Types.areEquivalent((String)name, (String)this.getQualifiedType());
    }

    public AnnotationElementSource setType(Class<?> clazz) {
        if (this.parent.requiresImport(clazz)) {
            this.parent.addImport(clazz);
        }
        return this.setType(clazz.getSimpleName());
    }

    public AnnotationElementSource setType(JavaType<?> source) {
        return this.setType(source.getQualifiedName());
    }

    public AnnotationElementSource setType(String typeName) {
        String simpleName = Types.toSimpleName((String)typeName);
        JavaAnnotationSource origin = this.getOrigin();
        if (!Strings.areEqual((String)typeName, (String)simpleName) && origin.requiresImport(typeName)) {
            origin.addImport(typeName);
        }
        PrimitiveType.Code primitive = PrimitiveType.toCode((String)typeName);
        PrimitiveType type = null;
        if (primitive != null) {
            type = this.ast.newPrimitiveType(primitive);
        } else if (!origin.requiresImport(typeName)) {
            if (Types.isArray((String)typeName)) {
                String arrayType = Types.stripArray((String)typeName);
                int arrayDimension = Types.getArrayDimension((String)typeName);
                type = Types.isPrimitive((String)arrayType) ? this.ast.newArrayType((org.eclipse.jdt.core.dom.Type)this.ast.newPrimitiveType(PrimitiveType.toCode((String)arrayType)), arrayDimension) : this.ast.newArrayType((org.eclipse.jdt.core.dom.Type)this.ast.newSimpleType((Name)this.ast.newSimpleName(arrayType)), arrayDimension);
            } else {
                type = this.ast.newSimpleType((Name)this.ast.newSimpleName(simpleName));
            }
        } else {
            String[] className = Types.tokenizeClassName((String)typeName);
            Name name = this.ast.newName(className);
            type = this.ast.newSimpleType(name);
        }
        this.member.setType((org.eclipse.jdt.core.dom.Type)type);
        return this;
    }

    public AnnotationElementSource.DefaultValue getDefaultValue() {
        return new DefaultValueImpl();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.member == null ? 0 : this.member.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationElementImpl other = (AnnotationElementImpl)obj;
        return !(this.member == null ? other.member != null : !this.member.equals((Object)other.member));
    }

    private class DefaultValueImpl
    implements AnnotationElementSource.DefaultValue {
        private DefaultValueImpl() {
        }

        public String getString() {
            return Strings.unquote((String)this.getLiteral());
        }

        public String getLiteral() {
            Expression expr = AnnotationElementImpl.this.member.getDefault();
            return expr == null ? null : expr.toString();
        }

        public <E extends Enum<E>> E getEnum(Class<E> type) {
            return this.convertLiteralToEnum(type, this.getLiteral());
        }

        public AnnotationSource<JavaAnnotationSource> getAnnotation() {
            Expression expr = AnnotationElementImpl.this.member.getDefault();
            if (expr instanceof org.eclipse.jdt.core.dom.Annotation) {
                return new AnnotationValue(AnnotationElementImpl.this.parent, expr);
            }
            return null;
        }

        public AnnotationElementSource.DefaultValue setLiteral(String value) {
            if (value == null) {
                AnnotationElementImpl.this.member.setDefault(null);
            } else {
                String stub = "public @interface Stub { String stub() default " + value + "; }";
                JavaAnnotationSource temp = (JavaAnnotationSource)JavaParser.parse((String)stub);
                AnnotationTypeMemberDeclaration internal = (AnnotationTypeMemberDeclaration)((AnnotationElementSource)temp.getAnnotationElements().get(0)).getInternal();
                AnnotationElementImpl.this.member.setDefault((Expression)ASTNode.copySubtree((AST)AnnotationElementImpl.this.ast, (ASTNode)internal.getDefault()));
            }
            return this;
        }

        public AnnotationElementSource.DefaultValue setString(String value) {
            Assert.notNull((Object)value, (String)"null not accepted");
            return this.setLiteral(Strings.enquote((String)value));
        }

        public <T extends Enum<T>> AnnotationElementSource.DefaultValue setEnum(T values) {
            return this.setEnumArray(new Enum[]{values});
        }

        public <T extends Enum<T>> AnnotationElementSource.DefaultValue setEnumArray(T ... values) {
            Assert.notNull(values, (String)"null array not accepted");
            ArrayList<String> literals = new ArrayList<String>();
            for (T value : values) {
                Assert.notNull(value, (String)"null value not accepted");
                AnnotationElementImpl.this.getOrigin().addImport(((Enum)value).getDeclaringClass());
                literals.add(((Enum)value).getDeclaringClass().getSimpleName() + "." + ((Enum)value).name());
            }
            return this.setLiteral(literals.size() == 1 ? (String)literals.get(0) : String.format("{%s}", Strings.join(literals, (String)",")));
        }

        public AnnotationSource<JavaAnnotationSource> setAnnotation() {
            AnnotationValue result = new AnnotationValue(AnnotationElementImpl.this.parent);
            AnnotationElementImpl.this.member.setDefault((Expression)result.getInternal());
            return result;
        }

        public <E extends Enum<E>> E[] getEnumArray(Class<E> type) {
            E instance;
            Expression expr = AnnotationElementImpl.this.member.getDefault();
            if (expr instanceof ArrayInitializer) {
                ArrayList<E> results = new ArrayList<E>();
                List arrayElements = ((ArrayInitializer)expr).expressions();
                for (Expression arrayElement : arrayElements) {
                    results.add(this.convertLiteralToEnum(type, arrayElement.toString()));
                }
                Enum[] result = (Enum[])Array.newInstance(type, results.size());
                return results.toArray(result);
            }
            if (expr != null && type.isInstance(instance = this.convertLiteralToEnum(type, expr.toString()))) {
                Enum[] result = (Enum[])Array.newInstance(type, 1);
                result[0] = instance;
                return result;
            }
            return null;
        }

        public AnnotationElementSource.DefaultValue setSingleClass(Class<?> value) {
            return this.setClassArray(value);
        }

        public AnnotationElementSource.DefaultValue setClassArray(Class<?> ... values) {
            Assert.notNull(values, (String)"null array not accepted");
            ArrayList<String> literals = new ArrayList<String>();
            for (Class<?> value : values) {
                Assert.notNull(value, (String)"null value not accepted");
                if (!value.isPrimitive()) {
                    AnnotationElementImpl.this.getOrigin().addImport(value);
                }
                literals.add(value.getSimpleName() + ".class");
            }
            return this.setLiteral(literals.size() == 1 ? (String)literals.get(0) : String.format("{%s}", Strings.join(literals, (String)",")));
        }

        private <E extends Enum<E>> E convertLiteralToEnum(Class<E> type, String literalValue) {
            for (Enum inst : (Enum[])type.getEnumConstants()) {
                String[] tokens = literalValue.split("\\.");
                if (tokens.length > 1) {
                    literalValue = tokens[tokens.length - 1];
                }
                if (!inst.name().equals(literalValue)) continue;
                return (E)inst;
            }
            return null;
        }

        public Class<?> getSingleClass() {
            Expression expr = AnnotationElementImpl.this.member.getDefault();
            if (expr instanceof TypeLiteral) {
                return this.resolveTypeLiteral((TypeLiteral)expr);
            }
            return null;
        }

        public Class<?>[] getClassArray() {
            Expression expr = AnnotationElementImpl.this.member.getDefault();
            if (expr instanceof ArrayInitializer) {
                ArrayList result = new ArrayList();
                List arrayElements = ((ArrayInitializer)expr).expressions();
                for (Expression arrayElement : arrayElements) {
                    result.add(this.resolveTypeLiteral((TypeLiteral)arrayElement));
                }
                return result.toArray(new Class[result.size()]);
            }
            if (expr instanceof TypeLiteral) {
                return new Class[]{this.resolveTypeLiteral((TypeLiteral)expr)};
            }
            return null;
        }

        private Class<?> resolveTypeLiteral(TypeLiteral typeLiteral) {
            TypeImpl<JavaAnnotationSource> type = new TypeImpl<JavaAnnotationSource>(AnnotationElementImpl.this.getOrigin(), typeLiteral.getType());
            if (type.isPrimitive()) {
                Class[] primitiveTypes;
                for (Class c : primitiveTypes = new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}) {
                    if (!c.getSimpleName().equals(type.getName())) continue;
                    return c;
                }
                return null;
            }
            String classname = type.getQualifiedName();
            try {
                return Class.forName(AnnotationElementImpl.this.getOrigin().resolveType(classname));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
    }

    private class AnnotationValue
    extends AnnotationImpl<JavaAnnotationSource, JavaAnnotationSource> {
        AnnotationValue(JavaAnnotationSource parent) {
            super(parent);
        }

        AnnotationValue(JavaAnnotationSource parent, Object internal) {
            super(parent, internal);
        }

        @Override
        protected void replace(org.eclipse.jdt.core.dom.Annotation oldNode, org.eclipse.jdt.core.dom.Annotation newNode) {
            AnnotationElementImpl.this.member.setDefault((Expression)newNode);
        }
    }
}

