/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.jboss.forge.parser.java.source.JavaClassSource;

public abstract class Formatter {
    public static String format(JavaClassSource javaClass) {
        return Formatter.format(javaClass.toString());
    }

    public static String format(String source) {
        Properties options = Formatter.readConfig("org.eclipse.jdt.core.prefs");
        CodeFormatter codeFormatter = ToolFactory.createCodeFormatter((Map)options);
        return Formatter.ensureCorrectNewLines(Formatter.formatFile(source, codeFormatter));
    }

    private static String formatFile(String contents, CodeFormatter codeFormatter) {
        Document doc = new Document(contents);
        try {
            TextEdit edit = codeFormatter.format(8, contents, 0, contents.length(), 0, null);
            if (edit == null) {
                return contents;
            }
            edit.apply((IDocument)doc);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        return doc.get();
    }

    private static Properties readConfig(String filename) {
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(Formatter.class.getResourceAsStream(filename));
            Properties formatterOptions = new Properties();
            formatterOptions.load(stream);
            Properties properties = formatterOptions;
            return properties;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static String ensureCorrectNewLines(String documentString) {
        String newLine = System.getProperty("line.separator");
        if (documentString.indexOf("\n") != -1 && documentString.indexOf(newLine) == -1) {
            return documentString.replaceAll("\n", newLine);
        }
        return documentString;
    }
}

