/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.plugins;

import java.util.ArrayList;
import java.util.List;
import org.jboss.forge.dependencies.Coordinate;
import org.jboss.forge.dependencies.Dependency;
import org.jboss.forge.maven.plugins.Configuration;
import org.jboss.forge.maven.plugins.ConfigurationBuilder;
import org.jboss.forge.maven.plugins.Execution;
import org.jboss.forge.maven.plugins.MavenPlugin;

public class MavenPluginImpl
implements MavenPlugin {
    private Coordinate coordinate;
    private Configuration configuration;
    private final List<Execution> executions = new ArrayList<Execution>();
    private boolean extensions;
    private List<Dependency> pluginDependencies = new ArrayList<Dependency>();

    public MavenPluginImpl() {
    }

    public MavenPluginImpl(MavenPlugin plugin) {
        this.setCoordinate(plugin.getCoordinate());
        this.setConfiguration(plugin.getConfig());
    }

    @Override
    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    public void setCoordinate(Coordinate coordinate) {
        this.coordinate = coordinate;
    }

    @Override
    public Configuration getConfig() {
        if (this.configuration == null) {
            this.configuration = ConfigurationBuilder.create();
        }
        return this.configuration;
    }

    @Override
    public List<Execution> listExecutions() {
        return this.executions;
    }

    @Override
    public boolean isExtensionsEnabled() {
        return this.extensions;
    }

    @Override
    public List<Dependency> getDirectDependencies() {
        return this.pluginDependencies;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("<plugin>");
        this.appendCoordinates(b, this.coordinate, true);
        if (this.extensions) {
            b.append("<extensions>true</extensions>");
        }
        if (this.configuration != null) {
            b.append(this.configuration.toString());
        }
        if (this.executions.size() > 0) {
            b.append("<executions>");
            for (Execution execution : this.executions) {
                b.append(execution.toString());
            }
            b.append("</executions>");
        }
        if (this.pluginDependencies.size() > 0) {
            b.append("<dependencies>");
            for (Dependency pluginDependency : this.pluginDependencies) {
                b.append("<dependency>");
                this.appendDependency(b, pluginDependency);
                b.append("</dependency>");
            }
            b.append("</dependencies>");
        }
        b.append("</plugin>");
        return b.toString();
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void addExecution(Execution execution) {
        this.executions.add(execution);
    }

    public void setExtenstions(boolean extenstions) {
        this.extensions = extenstions;
    }

    public void addPluginDependency(Dependency dependency) {
        this.pluginDependencies.add(dependency);
    }

    private void appendDependency(StringBuilder builder, Dependency appendDependency) {
        this.appendCoordinates(builder, appendDependency.getCoordinate(), true);
        if (!appendDependency.getExcludedCoordinates().isEmpty()) {
            builder.append("<exclusions>");
            for (Coordinate exclusion : appendDependency.getExcludedCoordinates()) {
                this.appendExclusion(builder, exclusion);
            }
            builder.append("</exclusions>");
        }
    }

    private void appendExclusion(StringBuilder builder, Coordinate exclusion) {
        builder.append("<exclusion>");
        this.appendCoordinates(builder, exclusion, false);
        builder.append("</exclusion>");
    }

    private void appendCoordinates(StringBuilder builder, Coordinate coordinate, boolean withVersion) {
        if (coordinate.getGroupId() != null) {
            builder.append("<groupId>").append(coordinate.getGroupId()).append("</groupId>");
        }
        if (coordinate.getArtifactId() != null) {
            builder.append("<artifactId>").append(coordinate.getArtifactId()).append("</artifactId>");
        }
        if (withVersion && coordinate.getVersion() != null) {
            builder.append("<version>").append(coordinate.getVersion()).append("</version>");
        }
    }
}

