/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.projects.facets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.jboss.forge.container.util.Predicate;
import org.jboss.forge.dependencies.Coordinate;
import org.jboss.forge.dependencies.Dependency;
import org.jboss.forge.dependencies.DependencyQuery;
import org.jboss.forge.dependencies.DependencyRepository;
import org.jboss.forge.dependencies.DependencyResolver;
import org.jboss.forge.dependencies.builder.DependencyBuilder;
import org.jboss.forge.dependencies.builder.DependencyQueryBuilder;
import org.jboss.forge.dependencies.util.Dependencies;
import org.jboss.forge.facets.AbstractFacet;
import org.jboss.forge.facets.Faceted;
import org.jboss.forge.maven.dependencies.MavenDependencyAdapter;
import org.jboss.forge.maven.dependencies.NonSnapshotDependencyFilter;
import org.jboss.forge.maven.projects.MavenFacet;
import org.jboss.forge.maven.projects.MavenFacetImpl;
import org.jboss.forge.projects.Project;
import org.jboss.forge.projects.facets.DependencyFacet;

@Dependent
public class MavenDependencyFacet
extends AbstractFacet<Project>
implements DependencyFacet {
    private final DependencyResolver resolver;

    @Inject
    public MavenDependencyFacet(DependencyResolver resolver) {
        this.resolver = resolver;
    }

    public boolean isInstalled() {
        return ((Project)this.getOrigin()).hasFacet(MavenFacet.class);
    }

    public boolean install() {
        return true;
    }

    public void addDirectDependency(Dependency dep) {
        this.removeDependency(dep);
        MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        Model pom = maven.getPOM();
        List dependencies = MavenDependencyAdapter.fromMavenList((List)pom.getDependencies());
        dependencies.add(dep);
        pom.setDependencies(MavenDependencyAdapter.toMavenList((List)dependencies));
        maven.setPOM(pom);
    }

    public boolean hasDirectDependency(Dependency dependency) {
        MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        Model pom = maven.getPOM();
        List dependencies = MavenDependencyAdapter.fromMavenList((List)pom.getDependencies());
        for (Dependency dep : dependencies) {
            if (!Dependencies.areEquivalent((Dependency)this.resolveProperties(dependency), (Dependency)dep)) continue;
            return true;
        }
        return false;
    }

    public void removeDependency(Dependency dep) {
        MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        Model pom = maven.getPOM();
        List dependencies = MavenDependencyAdapter.fromMavenList((List)pom.getDependencies());
        ArrayList<Dependency> toBeRemoved = new ArrayList<Dependency>();
        for (Dependency dependency : dependencies) {
            if (!Dependencies.areEquivalent((Dependency)dependency, (Dependency)this.resolveProperties(dep))) continue;
            toBeRemoved.add(dependency);
        }
        dependencies.removeAll(toBeRemoved);
        pom.setDependencies(MavenDependencyAdapter.toMavenList((List)dependencies));
        maven.setPOM(pom);
    }

    public List<Dependency> getDependencies() {
        MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        Model pom = maven.getPOM();
        List dependencies = MavenDependencyAdapter.fromMavenList((List)pom.getDependencies());
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        for (Dependency dependency : dependencies) {
            result.add(this.resolveProperties(dependency));
        }
        return result;
    }

    public Dependency getDirectDependency(Dependency dependency) {
        MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        Model pom = maven.getPOM();
        List dependencies = MavenDependencyAdapter.fromMavenList((List)pom.getDependencies());
        for (Dependency dep : dependencies) {
            if (!Dependencies.areEquivalent((Dependency)this.resolveProperties(dependency), (Dependency)dep)) continue;
            return this.resolveProperties(dep);
        }
        return null;
    }

    public boolean hasEffectiveDependency(Dependency dependency) {
        return this.getEffectiveDependency(this.resolveProperties(dependency)) != null;
    }

    public Dependency getEffectiveDependency(Dependency manDep) {
        for (Dependency dependency : this.getEffectiveDependencies()) {
            if (!Dependencies.areEquivalent((Dependency)dependency, (Dependency)this.resolveProperties(manDep))) continue;
            return this.resolveProperties(dependency);
        }
        return null;
    }

    public List<Dependency> getEffectiveDependencies() {
        MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        List deps = MavenDependencyAdapter.fromAetherList((List)((MavenFacetImpl)maven).getFullProjectBuildingResult().getDependencyResolutionResult().getDependencies());
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        for (Dependency dependency : deps) {
            result.add(this.resolveProperties(dependency));
        }
        return result;
    }

    public void addManagedDependency(Dependency manDep) {
        if (!this.hasEffectiveManagedDependency(this.resolveProperties(manDep))) {
            MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
            Model pom = maven.getPOM();
            DependencyManagement depMan = pom.getDependencyManagement();
            depMan = depMan != null ? depMan : new DependencyManagement();
            List managedDependencies = MavenDependencyAdapter.fromMavenList((List)depMan.getDependencies());
            managedDependencies.add(manDep);
            depMan.setDependencies(MavenDependencyAdapter.toMavenList((List)managedDependencies));
            pom.setDependencyManagement(depMan);
            maven.setPOM(pom);
        }
    }

    public void addDirectManagedDependency(Dependency dep) {
        this.removeManagedDependency(dep);
        MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        Model pom = maven.getPOM();
        DependencyManagement depMan = pom.getDependencyManagement();
        depMan = depMan != null ? depMan : new DependencyManagement();
        List managedDependencies = MavenDependencyAdapter.fromMavenList((List)depMan.getDependencies());
        managedDependencies.add(dep);
        depMan.setDependencies(MavenDependencyAdapter.toMavenList((List)managedDependencies));
        pom.setDependencyManagement(depMan);
        maven.setPOM(pom);
    }

    public boolean hasEffectiveManagedDependency(Dependency manDep) {
        return this.getEffectiveManagedDependency(this.resolveProperties(manDep)) != null;
    }

    public Dependency getEffectiveManagedDependency(Dependency manDep) {
        MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        DependencyManagement depMan = ((MavenFacetImpl)maven).getFullProjectBuildingResult().getProject().getDependencyManagement();
        List managedDependencies = depMan != null ? MavenDependencyAdapter.fromMavenList((List)depMan.getDependencies()) : new ArrayList();
        for (Dependency managedDependency : managedDependencies) {
            if (!Dependencies.areEquivalent((Dependency)managedDependency, (Dependency)this.resolveProperties(manDep))) continue;
            return this.resolveProperties(managedDependency);
        }
        return null;
    }

    public boolean hasDirectManagedDependency(Dependency managedDependency) {
        MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        Model pom = maven.getPOM();
        DependencyManagement depMan = pom.getDependencyManagement();
        List managedDependencies = depMan != null ? MavenDependencyAdapter.fromMavenList((List)depMan.getDependencies()) : new ArrayList();
        for (Dependency manDep : managedDependencies) {
            if (!Dependencies.areEquivalent((Dependency)this.resolveProperties(managedDependency), (Dependency)manDep)) continue;
            return true;
        }
        return false;
    }

    public void removeManagedDependency(Dependency manDep) {
        MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        Model pom = maven.getPOM();
        DependencyManagement depMan = pom.getDependencyManagement();
        depMan = depMan != null ? depMan : new DependencyManagement();
        List managedDependencies = MavenDependencyAdapter.fromMavenList((List)depMan.getDependencies());
        ArrayList<Dependency> toBeRemoved = new ArrayList<Dependency>();
        for (Dependency managedDependency : managedDependencies) {
            if (!Dependencies.areEquivalent((Dependency)managedDependency, (Dependency)manDep)) continue;
            toBeRemoved.add(managedDependency);
        }
        managedDependencies.removeAll(toBeRemoved);
        depMan.setDependencies(MavenDependencyAdapter.toMavenList((List)managedDependencies));
        pom.setDependencyManagement(depMan);
        maven.setPOM(pom);
    }

    public List<Dependency> getManagedDependencies() {
        MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        Model pom = maven.getPOM();
        DependencyManagement depMan = pom.getDependencyManagement();
        ArrayList managedDependencies = null;
        managedDependencies = depMan != null ? MavenDependencyAdapter.fromMavenList((List)depMan.getDependencies()) : new ArrayList();
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        for (Dependency dependency : managedDependencies) {
            result.add(this.resolveProperties(dependency));
        }
        return result;
    }

    public Dependency getManagedDependency(Dependency manDep) {
        MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        Model pom = maven.getPOM();
        DependencyManagement depMan = pom.getDependencyManagement();
        List managedDependencies = depMan != null ? MavenDependencyAdapter.fromMavenList((List)depMan.getDependencies()) : new ArrayList();
        for (Dependency managedDependency : managedDependencies) {
            if (!Dependencies.areEquivalent((Dependency)managedDependency, (Dependency)this.resolveProperties(manDep))) continue;
            return this.resolveProperties(managedDependency);
        }
        return null;
    }

    public Map<String, String> getProperties() {
        MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        Model pom = maven.getPOM();
        Properties properties = pom.getProperties();
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<Object, Object> o : properties.entrySet()) {
            result.put((String)o.getKey(), (String)o.getValue());
        }
        return result;
    }

    public void setProperty(String name, String value) {
        MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        Model pom = maven.getPOM();
        Properties properties = pom.getProperties();
        properties.put(name, value);
        maven.setPOM(pom);
    }

    public String getProperty(String name) {
        MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        Model pom = maven.getPOM();
        Properties properties = pom.getProperties();
        maven.setPOM(pom);
        return (String)properties.get(name);
    }

    public Dependency resolveProperties(Dependency dependency) {
        MavenFacet mvn = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        DependencyBuilder builder = DependencyBuilder.create((Dependency)dependency);
        builder.setGroupId(mvn.resolveProperties(dependency.getCoordinate().getGroupId()));
        builder.setArtifactId(mvn.resolveProperties(dependency.getCoordinate().getArtifactId()));
        builder.setVersion(mvn.resolveProperties(dependency.getCoordinate().getVersion()));
        builder.setClassifier(mvn.resolveProperties(dependency.getCoordinate().getClassifier()));
        builder.setPackaging(mvn.resolveProperties(dependency.getCoordinate().getPackaging()));
        builder.setScopeType(mvn.resolveProperties(dependency.getScopeType()));
        return builder;
    }

    public String removeProperty(String name) {
        MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        Model pom = maven.getPOM();
        Properties properties = pom.getProperties();
        String result = (String)properties.remove(name);
        maven.setPOM(pom);
        return result;
    }

    public List<Coordinate> resolveAvailableVersions(String gavs) {
        return this.resolveAvailableVersions((Dependency)DependencyBuilder.create((String)gavs));
    }

    public List<Coordinate> resolveAvailableVersions(Dependency dep) {
        DependencyQueryBuilder query = DependencyQueryBuilder.create((Coordinate)dep.getCoordinate()).setRepositories(this.getRepositories());
        if (dep.getCoordinate().getVersion() != null && !dep.getCoordinate().getVersion().contains("SNAPSHOT")) {
            query.setFilter((Predicate)new NonSnapshotDependencyFilter());
        }
        List versions = this.resolver.resolveVersions((DependencyQuery)query);
        return versions;
    }

    public List<Coordinate> resolveAvailableVersions(DependencyQuery query) {
        List versions = this.resolver.resolveVersions(query);
        return versions;
    }

    public void addRepository(String name, String url) {
        if (!this.hasRepository(url)) {
            MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
            Model pom = maven.getPOM();
            Repository repo = new Repository();
            repo.setId(name);
            repo.setUrl(url);
            pom.getRepositories().add(repo);
            maven.setPOM(pom);
        }
    }

    public List<DependencyRepository> getRepositories() {
        ArrayList<DependencyRepository> results = new ArrayList<DependencyRepository>();
        MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        Model pom = maven.getPOM();
        List repos = pom.getRepositories();
        for (Repository repo : repos) {
            results.add(new DependencyRepository(repo.getId(), repo.getUrl()));
        }
        return Collections.unmodifiableList(results);
    }

    public boolean hasRepository(String url) {
        if (url != null) {
            MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
            Model pom = maven.getPOM();
            List repositories = pom.getRepositories();
            for (Repository repo : repositories) {
                if (!repo.getUrl().trim().equals(url.trim())) continue;
                return true;
            }
        }
        return false;
    }

    public DependencyRepository removeRepository(String url) {
        if (url != null) {
            MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
            Model pom = maven.getPOM();
            List repos = pom.getRepositories();
            for (Repository repo : repos) {
                if (!repo.getUrl().equals(url.trim())) continue;
                repos.remove(repo);
                maven.setPOM(pom);
                return new DependencyRepository(repo.getId(), repo.getUrl());
            }
        }
        return null;
    }

    public List<Dependency> getDependenciesInScopes(String ... scopes) {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        List<Dependency> dependencies = this.getDependencies();
        block0: for (Dependency dependency : dependencies) {
            for (String scope : scopes) {
                if (dependency.getScopeType() != null && !dependency.getScopeType().equals(scope)) continue;
                dependency = this.resolveProperties(dependency);
                result.add(dependency);
                continue block0;
            }
        }
        return result;
    }

    public List<Dependency> getEffectiveDependenciesInScopes(String ... scopes) {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        List<Dependency> dependencies = this.getEffectiveDependencies();
        block0: for (Dependency dependency : dependencies) {
            for (String scope : scopes) {
                if (dependency.getScopeType() != null && !dependency.getScopeType().equals(scope)) continue;
                dependency = this.resolveProperties(dependency);
                result.add(dependency);
                continue block0;
            }
        }
        return result;
    }

    public void setOrigin(Project project) {
        super.setOrigin((Faceted)project);
    }
}

