/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.projects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Repository;
import org.jboss.forge.container.exception.ContainerException;
import org.jboss.forge.dependencies.Coordinate;
import org.jboss.forge.dependencies.Dependency;
import org.jboss.forge.dependencies.DependencyRepository;
import org.jboss.forge.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.dependencies.builder.DependencyBuilder;
import org.jboss.forge.dependencies.util.Dependencies;
import org.jboss.forge.facets.AbstractFacet;
import org.jboss.forge.facets.Faceted;
import org.jboss.forge.maven.plugins.Execution;
import org.jboss.forge.maven.plugins.MavenPlugin;
import org.jboss.forge.maven.plugins.MavenPluginAdapter;
import org.jboss.forge.maven.plugins.MavenPluginBuilder;
import org.jboss.forge.maven.projects.MavenFacet;
import org.jboss.forge.maven.projects.MavenPluginFacet;
import org.jboss.forge.projects.Project;

@Dependent
public class MavenPluginFacetImpl
extends AbstractFacet<Project>
implements MavenPluginFacet {
    private static final String DEFAULT_GROUPID = "org.apache.maven.plugins";

    public boolean install() {
        return true;
    }

    public boolean isInstalled() {
        return ((Project)this.getOrigin()).hasFacet(MavenFacet.class);
    }

    private List<Plugin> getPluginsPOM(Build build, boolean managedPlugin) {
        if (build != null) {
            if (managedPlugin) {
                PluginManagement pluginManagement = build.getPluginManagement();
                if (pluginManagement != null) {
                    return pluginManagement.getPlugins();
                }
            } else {
                return build.getPlugins();
            }
        }
        return Collections.emptyList();
    }

    private List<MavenPlugin> listConfiguredPlugins(boolean managedPlugin) {
        ArrayList<MavenPlugin> plugins = new ArrayList<MavenPlugin>();
        MavenFacet mavenCoreFacet = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        Build build = mavenCoreFacet.getPOM().getBuild();
        List<Plugin> pomPlugins = this.getPluginsPOM(build, managedPlugin);
        for (Plugin plugin : pomPlugins) {
            MavenPluginAdapter adapter = new MavenPluginAdapter(plugin);
            MavenPluginBuilder pluginBuilder = MavenPluginBuilder.create().setCoordinate((Coordinate)CoordinateBuilder.create().setGroupId(plugin.getGroupId()).setArtifactId(plugin.getArtifactId()).setVersion(plugin.getVersion())).setConfiguration(adapter.getConfig());
            for (Execution execution : adapter.listExecutions()) {
                pluginBuilder.addExecution(execution);
            }
            plugins.add((MavenPlugin)pluginBuilder);
        }
        return plugins;
    }

    private void addPlugin(MavenPlugin plugin, boolean managedPlugin) {
        MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        Model pom = maven.getPOM();
        Build build = pom.getBuild();
        if (build == null) {
            build = new Build();
        }
        if (managedPlugin) {
            PluginManagement pluginManagement = build.getPluginManagement();
            if (pluginManagement == null) {
                pluginManagement = new PluginManagement();
                build.setPluginManagement(pluginManagement);
            }
            pluginManagement.addPlugin((Plugin)new MavenPluginAdapter(plugin));
        } else {
            build.addPlugin((Plugin)new MavenPluginAdapter(plugin));
        }
        pom.setBuild(build);
        maven.setPOM(pom);
    }

    private MavenPlugin getPlugin(Dependency dependency, boolean managedPlugin) {
        String groupId = dependency.getCoordinate().getGroupId();
        groupId = groupId == null || groupId.equals("") ? DEFAULT_GROUPID : groupId;
        for (MavenPlugin mavenPlugin : this.listConfiguredPlugins(managedPlugin)) {
            Coordinate temp = mavenPlugin.getCoordinate();
            if (!temp.equals(CoordinateBuilder.create((Coordinate)temp).setGroupId(groupId))) continue;
            return mavenPlugin;
        }
        throw new ContainerException("Plugin " + dependency.getCoordinate() + " was not found");
    }

    public boolean hasPlugin(Dependency dependency, boolean managedPlugin) {
        try {
            this.getPlugin(dependency, managedPlugin);
            return true;
        }
        catch (ContainerException ex) {
            return false;
        }
    }

    private void removePlugin(Dependency dependency, boolean managedPlugin) {
        MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        Model pom = maven.getPOM();
        Build build = pom.getBuild();
        List<Plugin> pomPlugins = this.getPluginsPOM(build, managedPlugin);
        Iterator<Plugin> it = pomPlugins.iterator();
        while (it.hasNext()) {
            Plugin pomPlugin = it.next();
            DependencyBuilder pluginDep = DependencyBuilder.create().setGroupId(pomPlugin.getGroupId()).setArtifactId(pomPlugin.getArtifactId());
            if (!Dependencies.areEquivalent((Dependency)pluginDep, (Dependency)dependency)) continue;
            it.remove();
        }
        maven.setPOM(pom);
    }

    private void updatePlugin(MavenPlugin plugin, boolean managedPlugin) {
        MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        Model pom = maven.getPOM();
        Build build = pom.getBuild();
        List<Plugin> pomPlugins = this.getPluginsPOM(build, managedPlugin);
        for (Plugin pomPlugin : pomPlugins) {
            CoordinateBuilder pluginCoord = CoordinateBuilder.create().setGroupId(pomPlugin.getGroupId()).setArtifactId(pomPlugin.getArtifactId());
            if (!pluginCoord.equals(plugin.getCoordinate())) continue;
            MavenPluginAdapter adapter = new MavenPluginAdapter(plugin);
            pomPlugin.setConfiguration(adapter.getConfiguration());
            maven.setPOM(pom);
            break;
        }
    }

    public List<MavenPlugin> listConfiguredPlugins() {
        return this.listConfiguredPlugins(false);
    }

    public List<MavenPlugin> listConfiguredManagedPlugins() {
        return this.listConfiguredPlugins(true);
    }

    public void addPlugin(MavenPlugin plugin) {
        this.addPlugin(plugin, false);
    }

    public void addManagedPlugin(MavenPlugin plugin) {
        this.addPlugin(plugin, true);
    }

    public MavenPlugin getPlugin(Dependency dependency) {
        return this.getPlugin(dependency, false);
    }

    public MavenPlugin getManagedPlugin(Dependency dependency) {
        return this.getPlugin(dependency, true);
    }

    public boolean hasPlugin(Dependency dependency) {
        return this.hasPlugin(dependency, false);
    }

    public boolean hasManagedPlugin(Dependency dependency) {
        return this.hasPlugin(dependency, true);
    }

    public void removePlugin(Dependency dependency) {
        this.removePlugin(dependency, false);
    }

    public void removeManagedPlugin(Dependency dependency) {
        this.removePlugin(dependency, true);
    }

    public void updatePlugin(MavenPlugin plugin) {
        this.updatePlugin(plugin, false);
    }

    public void updateManagedPlugin(MavenPlugin plugin) {
        this.updatePlugin(plugin, true);
    }

    public void addPluginRepository(String name, String url) {
        if (!this.hasPluginRepository(url)) {
            MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
            Model pom = maven.getPOM();
            Repository repo = new Repository();
            repo.setId(name);
            repo.setUrl(url);
            pom.getPluginRepositories().add(repo);
            maven.setPOM(pom);
        }
    }

    public boolean hasPluginRepository(String url) {
        MavenFacet maven;
        Model pom;
        List repositories;
        if (url != null && (repositories = (pom = (maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class)).getPOM()).getPluginRepositories()) != null) {
            for (Repository repo : repositories) {
                if (!repo.getUrl().trim().equals(url.trim())) continue;
                repositories.remove(repo);
                maven.setPOM(pom);
                return true;
            }
        }
        return false;
    }

    public DependencyRepository removePluginRepository(String url) {
        if (url != null) {
            MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
            Model pom = maven.getPOM();
            List repos = pom.getPluginRepositories();
            for (Repository repo : repos) {
                if (!repo.getUrl().equals(url.trim())) continue;
                repos.remove(repo);
                maven.setPOM(pom);
                return new DependencyRepository(repo.getId(), repo.getUrl());
            }
        }
        return null;
    }

    public List<DependencyRepository> getPluginRepositories() {
        ArrayList<DependencyRepository> results = new ArrayList<DependencyRepository>();
        MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        Model pom = maven.getPOM();
        List repos = pom.getPluginRepositories();
        if (repos != null) {
            for (Repository repo : repos) {
                results.add(new DependencyRepository(repo.getId(), repo.getUrl()));
            }
        }
        return Collections.unmodifiableList(results);
    }

    public void setOrigin(Project project) {
        super.setOrigin((Faceted)project);
    }
}

