/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.projects;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.jboss.forge.container.util.Predicate;
import org.jboss.forge.dependencies.Coordinate;
import org.jboss.forge.dependencies.Dependency;
import org.jboss.forge.dependencies.DependencyQuery;
import org.jboss.forge.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.dependencies.builder.DependencyQueryBuilder;
import org.jboss.forge.dependencies.util.Dependencies;
import org.jboss.forge.dependencies.util.NonSnapshotDependencyFilter;
import org.jboss.forge.maven.plugins.Configuration;
import org.jboss.forge.maven.plugins.ConfigurationElement;
import org.jboss.forge.maven.plugins.ConfigurationImpl;
import org.jboss.forge.maven.plugins.MavenPlugin;
import org.jboss.forge.maven.plugins.MavenPluginAdapter;
import org.jboss.forge.maven.plugins.MavenPluginInstaller;
import org.jboss.forge.maven.projects.MavenPluginFacet;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.projects.Project;
import org.jboss.forge.projects.facets.DependencyFacet;

public class MavenPluginInstallImpl
implements MavenPluginInstaller {
    private boolean mergeWithExisting = true;
    private boolean preserveHierarchyPrecedence = true;

    private MavenPlugin install(Project project, MavenPlugin plugin, boolean managed) {
        MavenPluginFacet plugins = (MavenPluginFacet)project.getFacet(MavenPluginFacet.class);
        DependencyFacet deps = (DependencyFacet)project.getFacet(DependencyFacet.class);
        CoordinateBuilder pluginCoordinates = CoordinateBuilder.create().setGroupId(plugin.getCoordinate().getGroupId()).setArtifactId(plugin.getCoordinate().getArtifactId());
        MavenPlugin managedPlugin = null;
        if (plugins.hasManagedPlugin((Coordinate)pluginCoordinates)) {
            managedPlugin = plugins.getManagedPlugin((Coordinate)pluginCoordinates);
        }
        MavenPlugin existing = null;
        if (managed && plugins.hasEffectiveManagedPlugin((Coordinate)pluginCoordinates)) {
            existing = plugins.getEffectiveManagedPlugin((Coordinate)pluginCoordinates);
            if (plugins.hasManagedPlugin((Coordinate)pluginCoordinates) && !this.mergeWithExisting) {
                existing = this.diff(existing, plugins.getManagedPlugin((Coordinate)pluginCoordinates));
            }
        } else if (plugins.hasEffectivePlugin((Coordinate)pluginCoordinates)) {
            existing = plugins.getEffectivePlugin((Coordinate)pluginCoordinates);
            if (plugins.hasPlugin((Coordinate)pluginCoordinates) && !this.mergeWithExisting) {
                existing = this.diff(existing, plugins.getPlugin((Coordinate)pluginCoordinates));
            }
        }
        MavenPlugin filteredPlugin = plugin;
        if (existing != null && this.preserveHierarchyPrecedence) {
            filteredPlugin = this.diff(plugin, existing);
        }
        if (!managed && managedPlugin != null) {
            filteredPlugin = this.diff(filteredPlugin, managedPlugin);
        }
        MavenPlugin mergedPlugin = filteredPlugin;
        if (this.mergeWithExisting) {
            if (managed && managedPlugin != null) {
                mergedPlugin = plugins.merge(mergedPlugin, managedPlugin);
            } else if (!managed && plugins.hasPlugin((Coordinate)pluginCoordinates)) {
                mergedPlugin = plugins.merge(mergedPlugin, plugins.getPlugin((Coordinate)pluginCoordinates));
            }
        }
        String versionToInstall = plugin.getCoordinate().getVersion();
        if (mergedPlugin.getCoordinate().getVersion() == null && versionToInstall == null) {
            versionToInstall = this.promptVersion(deps, (Coordinate)pluginCoordinates, null).getVersion();
        }
        MavenPluginAdapter pluginToInstall = new MavenPluginAdapter(this.mergeWithExisting ? mergedPlugin : filteredPlugin);
        pluginToInstall.setVersion(versionToInstall);
        if (!managed) {
            MavenPluginAdapter mavenManagedPlugin = null;
            if (managedPlugin != null) {
                mavenManagedPlugin = new MavenPluginAdapter(managedPlugin);
                mavenManagedPlugin.setVersion(pluginToInstall.getVersion());
            } else {
                Plugin newManagedPlugin = new Plugin();
                newManagedPlugin.setGroupId(pluginToInstall.getGroupId());
                newManagedPlugin.setArtifactId(pluginToInstall.getArtifactId());
                newManagedPlugin.setVersion(pluginToInstall.getVersion());
                mavenManagedPlugin = new MavenPluginAdapter(newManagedPlugin);
            }
            this.addOrUpdatePlugin(deps, plugins, mavenManagedPlugin, true);
            pluginToInstall.setVersion(null);
        } else if (existing != null && Strings.areEqual((String)versionToInstall, (String)existing.getCoordinate().getVersion())) {
            pluginToInstall.setVersion(null);
        }
        return this.addOrUpdatePlugin(deps, plugins, pluginToInstall, managed);
    }

    public MavenPlugin install(Project project, MavenPlugin plugin) {
        return this.install(project, plugin, false);
    }

    public MavenPlugin installManaged(Project project, MavenPlugin plugin) {
        return this.install(project, plugin, true);
    }

    public boolean isInstalled(Project project, MavenPlugin plugin) {
        MavenPluginFacet plugins = (MavenPluginFacet)project.getFacet(MavenPluginFacet.class);
        return plugins.hasEffectivePlugin(plugin.getCoordinate());
    }

    private MavenPlugin addOrUpdatePlugin(DependencyFacet deps, MavenPluginFacet plugins, MavenPluginAdapter pluginToInstall, boolean managed) {
        CoordinateBuilder pluginCoordinates = CoordinateBuilder.create().setGroupId(pluginToInstall.getGroupId()).setArtifactId(pluginToInstall.getArtifactId());
        if (managed) {
            if (plugins.hasManagedPlugin((Coordinate)pluginCoordinates)) {
                plugins.updateManagedPlugin((MavenPlugin)pluginToInstall);
            } else {
                plugins.addManagedPlugin((MavenPlugin)pluginToInstall);
            }
        } else if (plugins.hasPlugin((Coordinate)pluginCoordinates)) {
            plugins.updatePlugin((MavenPlugin)pluginToInstall);
        } else {
            plugins.addPlugin((MavenPlugin)pluginToInstall);
        }
        return pluginToInstall;
    }

    private Coordinate promptVersion(DependencyFacet deps, Coordinate dependency, Predicate<Dependency> filter) {
        Coordinate result = dependency;
        List versions = deps.resolveAvailableVersions((DependencyQuery)DependencyQueryBuilder.create((Coordinate)dependency).setFilter((Predicate)(filter == null ? new NonSnapshotDependencyFilter() : filter)));
        if (versions.size() > 0) {
            Coordinate deflt;
            result = deflt = (Coordinate)versions.get(versions.size() - 1);
        }
        return result;
    }

    private MavenPluginAdapter diff(MavenPlugin dominant, MavenPlugin recessive) {
        MavenPluginAdapter merged = new MavenPluginAdapter(dominant);
        if (Dependencies.areEquivalent((Coordinate)dominant.getCoordinate(), (Coordinate)recessive.getCoordinate())) {
            if (Strings.areEqual((String)dominant.getCoordinate().getVersion(), (String)recessive.getCoordinate().getVersion())) {
                merged.setVersion(null);
            }
            if (dominant.isExtensionsEnabled() == recessive.isExtensionsEnabled()) {
                merged.setExtensions(null);
            }
            HashMap<String, String> cfgElmtsRefMap = new HashMap<String, String>();
            Configuration mergedConfiguration = merged.getConfig();
            if (dominant.getConfig() != null && recessive.getConfig() != null) {
                for (ConfigurationElement e : dominant.getConfig().listConfigurationElements()) {
                    cfgElmtsRefMap.put(e.getName(), e.toString());
                }
                for (ConfigurationElement e : recessive.getConfig().listConfigurationElements()) {
                    if (!cfgElmtsRefMap.containsKey(e.getName()) || !Strings.areEqual((String)((String)cfgElmtsRefMap.get(e.getName())), (String)e.toString())) continue;
                    mergedConfiguration.removeConfigurationElement(e.getName());
                }
            }
            merged.setConfig(mergedConfiguration);
            Map dominantExec = new MavenPluginAdapter(dominant).getExecutionsAsMap();
            Map recessiveExec = new MavenPluginAdapter(recessive).getExecutionsAsMap();
            Map mergedExec = merged.getExecutionsAsMap();
            if (dominantExec != null && recessiveExec != null) {
                for (Map.Entry entry : recessiveExec.entrySet()) {
                    PluginExecution pluginExecutionRecessive = (PluginExecution)entry.getValue();
                    PluginExecution pluginExecutionDominant = (PluginExecution)dominantExec.get(entry.getKey());
                    if (pluginExecutionRecessive == null || pluginExecutionDominant == null) continue;
                    PluginExecution pluginExecutionMerged = (PluginExecution)mergedExec.get(entry.getKey());
                    if (Strings.areEqual((String)pluginExecutionRecessive.getPhase(), (String)pluginExecutionDominant.getPhase())) {
                        pluginExecutionMerged.setPhase(null);
                    }
                    HashMap<String, Boolean> hasGoals = new HashMap<String, Boolean>();
                    for (String goal : pluginExecutionRecessive.getGoals()) {
                        hasGoals.put(goal, new Boolean(true));
                    }
                    for (String goal : pluginExecutionDominant.getGoals()) {
                        if (!((Boolean)hasGoals.get(goal)).booleanValue()) continue;
                        pluginExecutionMerged.removeGoal(goal);
                    }
                    HashMap<String, String> cfgExecElmtsRefMap = new HashMap<String, String>();
                    if (pluginExecutionRecessive.getConfiguration() == null || pluginExecutionDominant.getConfiguration() == null) continue;
                    ConfigurationImpl pluginExecutionRecessiveCfg = new ConfigurationImpl((Xpp3Dom)pluginExecutionRecessive.getConfiguration());
                    ConfigurationImpl pluginExecutionDominantCfg = new ConfigurationImpl((Xpp3Dom)pluginExecutionDominant.getConfiguration());
                    ConfigurationImpl pluginExecutionMergedCfg = new ConfigurationImpl((Xpp3Dom)pluginExecutionMerged.getConfiguration());
                    for (ConfigurationElement e : pluginExecutionDominantCfg.listConfigurationElements()) {
                        cfgExecElmtsRefMap.put(e.getName(), e.toString());
                    }
                    for (ConfigurationElement e : pluginExecutionRecessiveCfg.listConfigurationElements()) {
                        if (!cfgExecElmtsRefMap.containsKey(e.getName()) || !Strings.areEqual((String)((String)cfgExecElmtsRefMap.get(e.getName())), (String)e.toString())) continue;
                        pluginExecutionMergedCfg.removeConfigurationElement(e.getName());
                    }
                    if (!pluginExecutionMergedCfg.hasConfigurationElements()) {
                        pluginExecutionMerged.setConfiguration(null);
                    }
                    try {
                        pluginExecutionMerged.setConfiguration((Object)Xpp3DomBuilder.build((InputStream)new ByteArrayInputStream(pluginExecutionMergedCfg.toString().getBytes()), (String)"UTF-8"));
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("Exception while parsing configuration", ex);
                    }
                }
            }
        }
        return merged;
    }
}

