/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.projects.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.forge.resource.DirectoryResource;

public class NativeSystemCall {
    public static int execFromPath(String command, String[] parms, OutputStream out, DirectoryResource path) throws IOException {
        try {
            String[] commandTokens = parms == null ? new String[1] : new String[parms.length + 1];
            commandTokens[0] = command;
            if (commandTokens.length > 1) {
                System.arraycopy(parms, 0, commandTokens, 1, parms.length);
            }
            ProcessBuilder builder = new ProcessBuilder(commandTokens);
            builder.directory((File)path.getUnderlyingResourceObject());
            builder.redirectErrorStream(true);
            Process p = builder.start();
            InputStream stdout = p.getInputStream();
            Thread outThread = new Thread(new Receiver(stdout, out));
            outThread.start();
            outThread.join();
            return p.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static void exec(boolean wait, String command, String ... parms) throws IOException {
        String[] commandTokens = parms == null ? new String[1] : new String[parms.length + 1];
        commandTokens[0] = command;
        if (commandTokens.length > 1) {
            System.arraycopy(parms, 0, commandTokens, 1, parms.length);
        }
        Runtime.getRuntime().exec(commandTokens, null);
    }

    private static class Receiver
    implements Runnable {
        private final InputStream in;
        private final OutputStream out;

        public Receiver(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                int read;
                byte[] buf = new byte[1024];
                while ((read = this.in.read(buf)) != -1) {
                    this.out.write(buf, 0, read);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading input from child process", e);
            }
        }
    }
}

