/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.dependencies;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.apache.maven.repository.internal.MavenServiceLocator;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.jboss.forge.maven.dependencies.ClasspathWorkspaceReader;
import org.jboss.forge.maven.dependencies.ManualWagonProvider;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.connector.wagon.WagonProvider;
import org.sonatype.aether.connector.wagon.WagonRepositoryConnectorFactory;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.Proxy;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.repository.WorkspaceReader;
import org.sonatype.aether.spi.connector.RepositoryConnectorFactory;

public class MavenContainer {
    private static final String M2_HOME = System.getenv().get("M2_HOME");

    public List<RemoteRepository> getEnabledRepositoriesFromProfile(Settings settings) {
        ArrayList<RemoteRepository> settingsRepos = new ArrayList<RemoteRepository>();
        List activeProfiles = settings.getActiveProfiles();
        Map profiles = settings.getProfilesAsMap();
        for (String id : activeProfiles) {
            Profile profile = (Profile)profiles.get(id);
            if (profile == null) continue;
            List repositories = profile.getRepositories();
            for (Repository repository : repositories) {
                settingsRepos.add(new RemoteRepository(repository.getId(), repository.getLayout(), repository.getUrl()));
            }
        }
        return settingsRepos;
    }

    public Settings getSettings() {
        try {
            SettingsBuildingResult settingsBuildingResult;
            Settings effectiveSettings;
            DefaultSettingsBuilder settingsBuilder = new DefaultSettingsBuilderFactory().newInstance();
            DefaultSettingsBuildingRequest settingsRequest = new DefaultSettingsBuildingRequest();
            settingsRequest.setUserSettingsFile(new File(this.getUserHomeDir(), "/.m2/settings.xml"));
            if (M2_HOME != null) {
                settingsRequest.setGlobalSettingsFile(new File(M2_HOME, "/conf/settings.xml"));
            }
            if ((effectiveSettings = (settingsBuildingResult = settingsBuilder.build((SettingsBuildingRequest)settingsRequest)).getEffectiveSettings()).getLocalRepository() == null) {
                effectiveSettings.setLocalRepository(this.getUserHomePath() + "/.m2/repository");
            }
            return effectiveSettings;
        }
        catch (SettingsBuildingException e) {
            throw new RuntimeException(e);
        }
    }

    public RepositorySystem getRepositorySystem() {
        MavenServiceLocator locator = new MavenServiceLocator();
        locator.setServices(ModelBuilder.class, (Object[])new ModelBuilder[]{new DefaultModelBuilderFactory().newInstance()});
        locator.setServices(WagonProvider.class, (Object[])new WagonProvider[]{new ManualWagonProvider()});
        locator.addService(RepositoryConnectorFactory.class, WagonRepositoryConnectorFactory.class);
        RepositorySystem repositorySystem = (RepositorySystem)locator.getService(RepositorySystem.class);
        return repositorySystem;
    }

    public static Proxy convertFromMavenProxy(org.apache.maven.settings.Proxy proxy) {
        Proxy result = null;
        if (proxy != null) {
            Authentication auth = new Authentication(proxy.getUsername(), proxy.getPassword());
            result = new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), auth);
        }
        return result;
    }

    private File getUserHomeDir() {
        return new File(System.getProperty("user.home")).getAbsoluteFile();
    }

    private String getUserHomePath() {
        return this.getUserHomeDir().getAbsolutePath();
    }

    MavenRepositorySystemSession setupRepoSession(RepositorySystem repoSystem, Settings settings) {
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        session.setOffline(false);
        LocalRepository localRepo = new LocalRepository(new File(settings.getLocalRepository()), "");
        session.setLocalRepositoryManager(repoSystem.newLocalRepositoryManager(localRepo));
        session.setTransferErrorCachingEnabled(false);
        session.setNotFoundCachingEnabled(false);
        session.setWorkspaceReader((WorkspaceReader)new ClasspathWorkspaceReader());
        return session;
    }
}

