/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.dependencies;

import org.sonatype.aether.collection.DependencyCollectionContext;
import org.sonatype.aether.collection.DependencySelector;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.Exclusion;
import org.sonatype.aether.util.graph.selector.StaticDependencySelector;

public class AddonDependencySelector
implements DependencySelector {
    private static final String FORGE_ADDON = "forge-addon";
    private final int depth;
    private final Dependency parent;

    public AddonDependencySelector() {
        this.depth = 0;
        this.parent = null;
    }

    public AddonDependencySelector(Dependency parent, int depth) {
        this.depth = depth;
        this.parent = parent;
    }

    public boolean selectDependency(Dependency dependency) {
        boolean result = false;
        if (!this.isExcluded(dependency)) {
            boolean optional = dependency.isOptional();
            if (this.depth < 1) {
                return !optional;
            }
            String scope = dependency.getScope();
            String classifier = dependency.getArtifact().getClassifier();
            if ("test".equals(scope)) {
                return false;
            }
            result = FORGE_ADDON.equals(classifier) && this.depth == 1 || !FORGE_ADDON.equals(classifier) && !"provided".equals(scope) && !optional;
        }
        return result;
    }

    private boolean isExcluded(Dependency dependency) {
        boolean result = false;
        if (this.parent != null && this.parent.getExclusions().size() > 0) {
            for (Exclusion exclusion : this.parent.getExclusions()) {
                if (exclusion == null || exclusion.getArtifactId() == null || !exclusion.getArtifactId().equals(dependency.getArtifact().getArtifactId()) || exclusion.getGroupId() == null || !exclusion.getGroupId().equals(dependency.getArtifact().getGroupId())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
        if (this.depth > 0 && FORGE_ADDON.equals(context.getDependency().getArtifact().getClassifier())) {
            return new StaticDependencySelector(false);
        }
        return new AddonDependencySelector(context.getDependency(), this.depth + 1);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        AddonDependencySelector that = (AddonDependencySelector)obj;
        return this.depth == that.depth;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.depth;
        return hash;
    }
}

