/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.resources;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.ParserException;
import org.jboss.forge.parser.java.EnumConstant;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaEnum;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Member;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.parser.java.resources.AbstractJavaMemberResource;
import org.jboss.forge.parser.java.resources.EnumConstantResourceImpl;
import org.jboss.forge.parser.java.resources.JavaFieldResourceImpl;
import org.jboss.forge.parser.java.resources.JavaMethodResourceImpl;
import org.jboss.forge.parser.java.resources.JavaResource;
import org.jboss.forge.resource.AbstractFileResource;
import org.jboss.forge.resource.Resource;
import org.jboss.forge.resource.ResourceException;
import org.jboss.forge.resource.ResourceFacet;
import org.jboss.forge.resource.ResourceFactory;

public class JavaResourceImpl
extends AbstractFileResource<JavaResource>
implements JavaResource {
    @Inject
    public JavaResourceImpl(ResourceFactory factory) {
        super(factory, null);
    }

    public JavaResourceImpl(ResourceFactory factory, File file) {
        super(factory, file);
    }

    public Resource<?> getChild(String name) {
        List<Resource<?>> children = this.doListResources();
        ArrayList subset = new ArrayList();
        for (Resource<?> child : children) {
            if (name == null || !(child instanceof AbstractJavaMemberResource)) continue;
            String childName = child.getName();
            if (!((Member)child.getUnderlyingResourceObject()).getName().equals(name.trim()) && !childName.equals(name)) continue;
            subset.add(child);
        }
        if (subset.size() == 1) {
            return (Resource)subset.get(0);
        }
        if (subset.size() > 1) {
            throw new ResourceException("Ambiguous name [" + name + "], full type signature required");
        }
        return null;
    }

    protected synchronized List<Resource<?>> doListResources() {
        try {
            LinkedList list = new LinkedList();
            for (Member member : this.getJavaSource().getMembers()) {
                if (member instanceof Field) {
                    list.add((Resource<?>)new JavaFieldResourceImpl(this.getResourceFactory(), (Resource<?>)this, (Field<? extends JavaSource<?>>)((Field)member)));
                    continue;
                }
                if (member instanceof Method) {
                    list.add((Resource<?>)new JavaMethodResourceImpl(this.getResourceFactory(), (Resource<?>)this, (Method<? extends JavaSource<?>>)((Method)member)));
                    continue;
                }
                throw new UnsupportedOperationException("Unknown member type: " + member);
            }
            if (this.getJavaSource() instanceof JavaEnum) {
                for (EnumConstant e : ((JavaEnum)this.getJavaSource()).getEnumConstants()) {
                    list.add((Resource<?>)new EnumConstantResourceImpl(this.getResourceFactory(), (Resource<?>)this, (EnumConstant<JavaEnum>)e));
                }
            }
            return list;
        }
        catch (ParserException e) {
            return Collections.emptyList();
        }
        catch (FileNotFoundException e) {
            return Collections.emptyList();
        }
    }

    public JavaResourceImpl setContents(JavaSource<?> source) {
        this.setContents(source.toString());
        return this;
    }

    public JavaSource<?> getJavaSource() throws FileNotFoundException {
        return JavaParser.parse((File)this.file);
    }

    public JavaResourceImpl createFrom(File file) {
        return new JavaResourceImpl(this.resourceFactory, file);
    }

    public String toString() {
        try {
            return this.getJavaSource().getQualifiedName();
        }
        catch (FileNotFoundException e) {
            throw new ResourceException((Throwable)e);
        }
        catch (Exception e) {
            return this.getName();
        }
    }

    public boolean supports(ResourceFacet type) {
        return false;
    }
}

