/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.projects;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.container.addons.AddonRegistry;
import org.jboss.forge.container.services.ExportedInstance;
import org.jboss.forge.container.spi.ListenerRegistration;
import org.jboss.forge.container.util.Predicate;
import org.jboss.forge.facets.Facet;
import org.jboss.forge.projects.Project;
import org.jboss.forge.projects.ProjectFacet;
import org.jboss.forge.projects.ProjectFactory;
import org.jboss.forge.projects.ProjectListener;
import org.jboss.forge.projects.ProjectLocator;
import org.jboss.forge.projects.ProjectType;
import org.jboss.forge.resource.DirectoryResource;

@Singleton
public class ProjectFactoryImpl
implements ProjectFactory {
    @Inject
    private AddonRegistry registry;
    private final List<ProjectListener> projectListeners = new ArrayList<ProjectListener>();

    public Project findProject(DirectoryResource target) {
        return this.findProject(target, null);
    }

    public Project findProject(DirectoryResource target, Predicate<Project> filter) {
        if (filter == null) {
            filter = new Predicate<Project>(){

                public boolean accept(Project type) {
                    return true;
                }
            };
        }
        Project result = null;
        for (ExportedInstance instance : this.registry.getExportedInstances(ProjectLocator.class)) {
            DirectoryResource r = target;
            while (r != null && result == null) {
                ProjectLocator locator = (ProjectLocator)instance.get();
                if (locator.containsProject(target) && !filter.accept((Object)(result = locator.createProject(target)))) {
                    result = null;
                }
                r = r.getParent() == null ? null : (DirectoryResource)r.getParent().reify(DirectoryResource.class);
            }
        }
        return result;
    }

    public Project createProject(DirectoryResource target, ProjectType ... types) {
        ExportedInstance instance;
        ProjectLocator locator;
        Project result = null;
        Iterator i$ = this.registry.getExportedInstances(ProjectLocator.class).iterator();
        while (i$.hasNext() && (result = (locator = (ProjectLocator)(instance = (ExportedInstance)i$.next()).get()).createProject(target)) == null) {
        }
        if (result != null && types != null) {
            for (ProjectType type : types) {
                Iterable facetTypes = type.getRequiredFacets();
                if (facetTypes == null) continue;
                for (Class facetType : facetTypes) {
                    ProjectFacet facet = (ProjectFacet)this.registry.getExportedInstance(facetType).get();
                    facet.setOrigin(result);
                    if (result.install((Facet)facet)) continue;
                    throw new IllegalStateException("Could not install Facet [" + facet + "] of type [" + facetType + "] into Project [" + result + "]");
                }
            }
        }
        if (result != null) {
            this.fireProjectCreated(result);
        }
        return result;
    }

    private void fireProjectCreated(Project project) {
        for (ProjectListener listener : this.projectListeners) {
            listener.projectCreated(project);
        }
    }

    public ListenerRegistration<ProjectListener> addProjectListener(final ProjectListener listener) {
        this.projectListeners.add(listener);
        return new ListenerRegistration<ProjectListener>(){

            public ProjectListener removeListener() {
                ProjectFactoryImpl.this.projectListeners.remove(listener);
                return listener;
            }
        };
    }
}

