/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.projects.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jboss.forge.container.addons.AddonRegistry;
import org.jboss.forge.container.services.ExportedInstance;
import org.jboss.forge.convert.Converter;
import org.jboss.forge.projects.Project;
import org.jboss.forge.projects.ProjectFactory;
import org.jboss.forge.projects.ProjectType;
import org.jboss.forge.projects.facets.MetadataFacet;
import org.jboss.forge.resource.DirectoryResource;
import org.jboss.forge.resource.Resource;
import org.jboss.forge.resource.ResourceFactory;
import org.jboss.forge.ui.context.UIBuilder;
import org.jboss.forge.ui.context.UIContext;
import org.jboss.forge.ui.context.UISelection;
import org.jboss.forge.ui.context.UIValidationContext;
import org.jboss.forge.ui.input.SingleValued;
import org.jboss.forge.ui.input.UIInput;
import org.jboss.forge.ui.input.UISelectOne;
import org.jboss.forge.ui.metadata.UICommandMetadata;
import org.jboss.forge.ui.result.NavigationResult;
import org.jboss.forge.ui.result.Result;
import org.jboss.forge.ui.result.Results;
import org.jboss.forge.ui.util.Categories;
import org.jboss.forge.ui.util.Metadata;
import org.jboss.forge.ui.wizard.UIWizard;

public class NewProjectWizard
implements UIWizard {
    @Inject
    private AddonRegistry registry;
    @Inject
    private ProjectFactory projectFactory;
    @Inject
    private ResourceFactory resourceFactory;
    @Inject
    private UIInput<String> named;
    @Inject
    private UIInput<String> topLevelPackage;
    @Inject
    private UIInput<DirectoryResource> targetLocation;
    @Inject
    private UIInput<Boolean> overwrite;
    @Inject
    private UISelectOne<ProjectType> type;

    public UICommandMetadata getMetadata() {
        return Metadata.forCommand(this.getClass()).name("New Project").description("Create a new project").category(Categories.create((String[])new String[]{"Project", "Generation"}));
    }

    public boolean isEnabled(UIContext context) {
        return true;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.named.setLabel("Project name:");
        this.named.setRequired(true);
        this.topLevelPackage.setLabel("Top level package:");
        this.topLevelPackage.setRequired(true);
        this.targetLocation.setLabel("Project location:");
        UISelection currentSelection = builder.getUIContext().getInitialSelection();
        if (currentSelection != null) {
            Resource resource = (Resource)currentSelection.get();
            if (resource instanceof DirectoryResource) {
                this.targetLocation.setDefaultValue((Object)((DirectoryResource)resource));
            }
        } else {
            this.targetLocation.setDefaultValue((Object)this.resourceFactory.create(DirectoryResource.class, (Object)new File("")));
        }
        this.overwrite.setLabel("Overwrite existing project location");
        ((UIInput)this.overwrite.setDefaultValue((Object)false)).setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return NewProjectWizard.this.targetLocation.getValue() != null && ((DirectoryResource)NewProjectWizard.this.targetLocation.getValue()).exists() && !((DirectoryResource)NewProjectWizard.this.targetLocation.getValue()).listResources().isEmpty();
            }
        });
        this.type.setLabel("Project Type:");
        this.type.setRequired(true);
        this.type.setItemLabelConverter((Converter)new Converter<ProjectType, String>(){

            public String convert(ProjectType source) {
                return source == null ? null : source.getType();
            }
        });
        ArrayList<ProjectType> projectTypes = new ArrayList<ProjectType>();
        for (ExportedInstance instance : this.registry.getExportedInstances(ProjectType.class)) {
            ProjectType projectType = (ProjectType)instance.get();
            projectTypes.add(projectType);
            this.type.setDefaultValue((Object)projectType);
        }
        this.type.setValueChoices(projectTypes);
        builder.add(this.named).add(this.topLevelPackage).add(this.targetLocation).add(this.overwrite).add(this.type);
    }

    public void validate(UIValidationContext context) {
        if (!((String)this.topLevelPackage.getValue()).matches("(?i)(~\\.)?([a-z0-9_]+\\.?)+[a-z0-9_]")) {
            context.addValidationError(this.topLevelPackage, "Top level package must be a valid package name.");
        }
        if (this.overwrite.isEnabled() && !((Boolean)this.overwrite.getValue()).booleanValue()) {
            context.addValidationError(this.targetLocation, "Target location is not empty.");
        }
    }

    public Result execute(UIContext context) throws Exception {
        Result result = Results.success((String)"New project has been created.");
        DirectoryResource directory = (DirectoryResource)this.targetLocation.getValue();
        DirectoryResource targetDir = directory.getChildDirectory((String)this.named.getValue());
        if (targetDir.mkdirs() || ((Boolean)this.overwrite.getValue()).booleanValue()) {
            Project project = this.projectFactory.createProject(targetDir, new ProjectType[]{(ProjectType)this.type.getValue()});
            if (project != null) {
                MetadataFacet metadataFacet = (MetadataFacet)project.getFacet(MetadataFacet.class);
                metadataFacet.setProjectName((String)this.named.getValue());
                metadataFacet.setTopLevelPackage((String)this.topLevelPackage.getValue());
                context.setAttribute(Project.class, (Object)project);
            } else {
                result = Results.fail((String)("Could not create project of type: [" + this.type.getValue() + "]"));
            }
        } else {
            result = Results.fail((String)("Could not create target location: " + targetDir));
        }
        return result;
    }

    public UIInput<String> getNamed() {
        return this.named;
    }

    public UIInput<DirectoryResource> getTargetLocation() {
        return this.targetLocation;
    }

    public UIInput<Boolean> getOverwrite() {
        return this.overwrite;
    }

    public UISelectOne<ProjectType> getType() {
        return this.type;
    }

    public SingleValued<UIInput<String>, String> getTopLevelPackage() {
        return this.topLevelPackage;
    }

    public NavigationResult next(UIContext context) throws Exception {
        if (this.type.getValue() != null) {
            return Results.navigateTo((Class)((ProjectType)this.type.getValue()).getSetupFlow());
        }
        return null;
    }
}

