/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.resource;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.jboss.forge.container.util.OperatingSystemUtils;
import org.jboss.forge.resource.AbstractFileResource;
import org.jboss.forge.resource.DirectoryResource;
import org.jboss.forge.resource.Resource;
import org.jboss.forge.resource.ResourceException;
import org.jboss.forge.resource.ResourceFactory;

public class DirectoryResourceImpl
extends AbstractFileResource<DirectoryResource>
implements DirectoryResource {
    private volatile List<Resource<?>> listCache;

    public DirectoryResourceImpl(ResourceFactory factory, File file) {
        super(factory, file);
    }

    protected List<Resource<?>> doListResources() {
        if (this.isStale()) {
            this.listCache = null;
        }
        if (this.listCache == null) {
            this.listCache = new LinkedList();
            File[] files = this.file.listFiles();
            if (files != null) {
                for (File f : files) {
                    this.listCache.add(this.resourceFactory.create((Object)f));
                }
            }
        }
        return this.listCache;
    }

    public Resource<?> getChild(String name) {
        return this.resourceFactory.create((Object)new File(this.file.getAbsolutePath(), name));
    }

    public DirectoryResourceImpl getChildDirectory(String name) throws ResourceException {
        Object result = this.getChild(name);
        if (!(result instanceof DirectoryResourceImpl) && result.exists()) {
            throw new ResourceException("The resource [" + result.getFullyQualifiedName() + "] is not a DirectoryResource");
        }
        if (!(result instanceof DirectoryResourceImpl)) {
            result = new DirectoryResourceImpl(this.resourceFactory, new File(this.file.getAbsoluteFile(), name));
        }
        return (DirectoryResourceImpl)((Object)result);
    }

    public DirectoryResourceImpl getOrCreateChildDirectory(String name) {
        DirectoryResourceImpl child = this.getChildDirectory(name);
        if (!child.exists()) {
            child.mkdir();
        }
        return child;
    }

    public <E, T extends Resource<E>> T getChildOfType(Class<T> type, String name) throws ResourceException {
        Resource result;
        Resource child = this.getChild(name);
        if (type.isAssignableFrom(child.getClass())) {
            result = child;
        } else {
            if (child.exists()) {
                throw new ResourceException("Requested resource [" + name + "] was not of type [" + type.getName() + "], but was instead [" + child.getClass().getName() + "]");
            }
            Object underlyingResource = child.getUnderlyingResourceObject();
            result = this.resourceFactory.create(type, underlyingResource);
        }
        return (T)result;
    }

    public DirectoryResourceImpl createTempResource() {
        try {
            File tempFile = File.createTempFile("forgetemp", "");
            tempFile.delete();
            return this.createFrom(tempFile);
        }
        catch (IOException e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public DirectoryResourceImpl createFrom(File file) {
        if (file.exists() && !file.isDirectory()) {
            throw new ResourceException("File reference is not a directory: " + file.getAbsolutePath());
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return new DirectoryResourceImpl(this.resourceFactory, file);
    }

    public synchronized Resource<?> getParent() {
        if (this.parent == null) {
            File parentFile = this.file.getParentFile();
            if (parentFile == null) {
                return null;
            }
            this.parent = this.createFrom(parentFile);
        }
        return this.parent;
    }

    public String getName() {
        String fileName = this.file.getName();
        return OperatingSystemUtils.isWindows() && fileName.length() == 0 ? this.file.getPath() : fileName;
    }

    public boolean equals(Object obj) {
        return obj instanceof DirectoryResourceImpl && ((DirectoryResourceImpl)((Object)obj)).file.equals(this.file);
    }
}

