/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.resource;

import java.io.File;
import java.io.IOException;
import org.jboss.forge.resource.ChangeSetImpl;
import org.jboss.forge.resource.Resource;
import org.jboss.forge.resource.ResourceException;
import org.jboss.forge.resource.ResourceFactoryImpl;
import org.jboss.forge.resource.transaction.ChangeSet;
import org.jboss.forge.resource.transaction.ResourceTransaction;

public class ResourceTransactionImpl
implements ResourceTransaction {
    private File tempWorkspace;
    private ChangeSetImpl changeSet = new ChangeSetImpl();
    private ResourceFactoryImpl factoryImpl;

    public ResourceTransactionImpl(ResourceFactoryImpl factoryImpl) throws ResourceException {
        try {
            this.tempWorkspace = File.createTempFile("Forge_RT", null);
        }
        catch (IOException io) {
            throw new ResourceException((Throwable)io);
        }
        this.tempWorkspace.delete();
        this.tempWorkspace.mkdir();
        this.factoryImpl = factoryImpl;
    }

    public void commit() throws ResourceException {
        this.factoryImpl.unsetTransaction();
    }

    public void rollback() throws ResourceException {
        this.factoryImpl.unsetTransaction();
    }

    public <TYPE> Resource<TYPE> decorateResource(Resource<TYPE> resource) {
        this.changeSet.addResource(resource);
        return resource;
    }

    public ChangeSet getChangeSet() {
        return this.changeSet;
    }
}

