/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.jboss.forge.container.util.Assert;
import org.jboss.forge.resource.Resource;
import org.jboss.forge.resource.ResourceFacet;
import org.jboss.forge.resource.ResourceFactory;
import org.jboss.forge.resource.URLResource;
import org.jboss.forge.resource.VirtualResource;

public class URLResourceImpl
extends VirtualResource<URL>
implements URLResource {
    private final URL resource;

    public URLResourceImpl(ResourceFactory factory, URL resource) {
        super(factory, null);
        Assert.notNull((Object)resource, (String)"URL resource cannot be null");
        this.resource = resource;
    }

    protected URLResourceImpl(ResourceFactory factory, Resource<?> parent, URL resource) {
        super(factory, parent);
        Assert.notNull((Object)resource, (String)"URL resource cannot be null");
        this.resource = resource;
    }

    public boolean delete() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot delete URL resources.");
    }

    public boolean delete(boolean recursive) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot delete URL resources.");
    }

    public String getName() {
        return this.resource.toExternalForm();
    }

    public URL getUnderlyingResourceObject() {
        return this.resource;
    }

    public InputStream getResourceInputStream() {
        try {
            return this.resource.openStream();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not open stream", e);
        }
    }

    public boolean exists() {
        try {
            HttpURLConnection connection = (HttpURLConnection)this.resource.openConnection();
            connection.setRequestMethod("HEAD");
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    protected List<Resource<?>> doListResources() {
        return Collections.emptyList();
    }

    public boolean supports(ResourceFacet type) {
        return false;
    }
}

