/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.resource;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.container.addons.AddonRegistry;
import org.jboss.forge.container.services.ExportedInstance;
import org.jboss.forge.resource.Resource;
import org.jboss.forge.resource.ResourceException;
import org.jboss.forge.resource.ResourceFactory;
import org.jboss.forge.resource.ResourceGenerator;
import org.jboss.forge.resource.ResourceTransactionImpl;
import org.jboss.forge.resource.events.ResourceEvent;
import org.jboss.forge.resource.transaction.ResourceTransaction;
import org.jboss.forge.resource.transaction.ResourceTransactionManager;

@Singleton
public class ResourceFactoryImpl
implements ResourceFactory,
ResourceTransactionManager {
    @Inject
    private BeanManager manager;
    @Inject
    private AddonRegistry registry;
    private ResourceTransactionImpl transaction;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E, T extends Resource<E>> T create(Class<T> type, E underlyingResource) {
        Object result = null;
        ResourceFactoryImpl resourceFactoryImpl = this;
        synchronized (resourceFactoryImpl) {
            HashMap<Class, Resource> generated = new HashMap<Class, Resource>();
            for (ExportedInstance<ResourceGenerator> exportedInstance : this.getRegisteredResourceGenerators()) {
                Class resourceType;
                ResourceGenerator generator = (ResourceGenerator)exportedInstance.get();
                if (generator.handles(type, underlyingResource) && type.isAssignableFrom(resourceType = generator.getResourceType(type, underlyingResource))) {
                    generated.put(resourceType, generator.getResource((ResourceFactory)this, type, underlyingResource));
                }
                exportedInstance.release((Object)generator);
            }
            for (Map.Entry entry : generated.entrySet()) {
                Class generatedType = (Class)entry.getKey();
                Resource resource = (Resource)entry.getValue();
                if (result != null && !result.getClass().isAssignableFrom(resource.getClass())) continue;
                result = resource;
                if (!generatedType.equals(type)) continue;
                break;
            }
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> Resource<E> create(E underlyingResource) {
        Resource result = null;
        ResourceFactoryImpl resourceFactoryImpl = this;
        synchronized (resourceFactoryImpl) {
            ArrayList<Resource> generated = new ArrayList<Resource>();
            for (ExportedInstance<ResourceGenerator> instance : this.getRegisteredResourceGenerators()) {
                ResourceGenerator generator = (ResourceGenerator)instance.get();
                if (generator.handles(Resource.class, underlyingResource)) {
                    Resource resource = generator.getResource((ResourceFactory)this, Resource.class, underlyingResource);
                    generated.add(resource);
                }
                instance.release((Object)generator);
            }
            for (Resource resource : generated) {
                if (result != null && !result.getClass().isAssignableFrom(resource.getClass())) continue;
                result = resource;
            }
        }
        if (result != null && this.transaction != null) {
            result = this.transaction.decorateResource(result);
        }
        return result;
    }

    private Iterable<ExportedInstance<ResourceGenerator>> getRegisteredResourceGenerators() {
        return this.registry.getExportedInstances(ResourceGenerator.class);
    }

    public ResourceFactory fireEvent(ResourceEvent event) {
        this.manager.fireEvent((Object)event, new Annotation[0]);
        return this;
    }

    public ResourceTransaction getCurrentTransaction() {
        return this.transaction;
    }

    public ResourceTransaction startTransaction() throws ResourceException {
        if (this.transaction != null) {
            throw new ResourceException("Transaction already exists!");
        }
        this.transaction = new ResourceTransactionImpl(this);
        return this.transaction;
    }

    void unsetTransaction() {
        this.transaction = null;
    }
}

