/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.ui.util;

import java.util.ArrayList;
import org.jboss.forge.container.util.Strings;
import org.jboss.forge.convert.CompositeConverter;
import org.jboss.forge.convert.Converter;
import org.jboss.forge.convert.ConverterFactory;
import org.jboss.forge.ui.facets.HintsFacet;
import org.jboss.forge.ui.hints.InputType;
import org.jboss.forge.ui.input.InputComponent;
import org.jboss.forge.ui.input.ManyValued;
import org.jboss.forge.ui.input.SelectComponent;
import org.jboss.forge.ui.input.SingleValued;

public final class InputComponents {
    public static InputType getInputType(InputComponent<?, ?> input) {
        InputType result = null;
        if (input.hasFacet(HintsFacet.class)) {
            HintsFacet facet = (HintsFacet)input.getFacet(HintsFacet.class);
            result = facet.getInputType();
        }
        return result;
    }

    public static Object getValueFor(InputComponent<?, ?> component) {
        if (component instanceof SingleValued) {
            return ((SingleValued)((Object)component)).getValue();
        }
        if (component instanceof ManyValued) {
            return ((ManyValued)((Object)component)).getValue();
        }
        return null;
    }

    public static void setValueFor(ConverterFactory converterFactory, InputComponent<?, Object> component, Object value) {
        if (component instanceof SingleValued) {
            InputComponents.setSingleInputValue(converterFactory, component, value);
        } else if (component instanceof ManyValued) {
            InputComponents.setManyInputValue(converterFactory, component, value);
        }
    }

    private static void setSingleInputValue(ConverterFactory converterFactory, InputComponent<?, Object> input, Object value) {
        Object convertedType = value != null ? InputComponents.convertToUIInputValue(converterFactory, input, value) : null;
        ((SingleValued)((Object)input)).setValue(convertedType);
    }

    private static void setManyInputValue(ConverterFactory converterFactory, InputComponent<?, Object> input, Object value) {
        ArrayList<Object> convertedValues;
        if (value != null) {
            ArrayList<Object> convertedValuesList = new ArrayList<Object>();
            if (value instanceof Iterable) {
                for (Object itValue : (Iterable)value) {
                    convertedValuesList.add(InputComponents.convertToUIInputValue(converterFactory, input, itValue));
                }
            } else {
                convertedValuesList.add(InputComponents.convertToUIInputValue(converterFactory, input, value));
            }
            convertedValues = convertedValuesList;
        } else {
            convertedValues = null;
        }
        ((ManyValued)((Object)input)).setValue(convertedValues);
    }

    private static Object convertToUIInputValue(ConverterFactory converterFactory, InputComponent<?, Object> input, Object value) {
        Object convertedType = value;
        Class<?> sourceType = value.getClass();
        Class<Object> targetType = input.getValueType();
        Converter<String, Object> valueConverter = input.getValueConverter();
        if (!targetType.isAssignableFrom(sourceType)) {
            if (valueConverter != null) {
                if (value instanceof String) {
                    convertedType = valueConverter.convert((Object)((String)value));
                } else {
                    Converter stringConverter = converterFactory.getConverter(sourceType, String.class);
                    CompositeConverter compositeConverter = new CompositeConverter(new Converter[]{stringConverter, valueConverter});
                    convertedType = compositeConverter.convert(value);
                }
            } else {
                Converter converter = converterFactory.getConverter(sourceType, targetType);
                convertedType = converter.convert(value);
            }
        }
        return convertedType;
    }

    public static boolean hasValue(InputComponent<?, ?> input) {
        Object value = InputComponents.getValueFor(input);
        boolean ret = value == null ? false : !(value instanceof String) || !value.toString().isEmpty();
        return ret;
    }

    public static String validateRequired(InputComponent<?, ?> input) {
        String requiredMessage = null;
        if (input.isRequired() && !InputComponents.hasValue(input) && Strings.isNullOrEmpty((String)(requiredMessage = input.getRequiredMessage()))) {
            String labelValue;
            String string = labelValue = input.getLabel() == null ? input.getName() : input.getLabel();
            if (labelValue.endsWith(":")) {
                labelValue = labelValue.substring(0, labelValue.length() - 1);
            }
            requiredMessage = labelValue + " is required";
        }
        return requiredMessage;
    }

    public static Converter<?, String> getItemLabelConverter(ConverterFactory converterFactory, SelectComponent<?, ?> input) {
        Converter converter = input.getItemLabelConverter();
        if (converter == null && converterFactory != null) {
            converter = converterFactory.getConverter(input.getValueType(), String.class);
        }
        return converter;
    }
}

