/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.ui.impl;

import java.util.concurrent.Callable;
import javax.enterprise.inject.Vetoed;
import org.jboss.forge.container.util.Callables;
import org.jboss.forge.convert.Converter;
import org.jboss.forge.facets.AbstractFaceted;
import org.jboss.forge.ui.facets.HintsFacet;
import org.jboss.forge.ui.input.InputComponent;

@Vetoed
public abstract class UIInputComponentBase<IMPLTYPE extends InputComponent<IMPLTYPE, VALUETYPE>, VALUETYPE>
extends AbstractFaceted<HintsFacet>
implements InputComponent<IMPLTYPE, VALUETYPE> {
    private final String name;
    private String label;
    private Callable<Boolean> enabled = Callables.returning((Object)Boolean.TRUE);
    private Callable<Boolean> required = Callables.returning((Object)Boolean.FALSE);
    private String requiredMessage;
    private Class<VALUETYPE> type;
    private Converter<String, VALUETYPE> valueConverter;

    public UIInputComponentBase(String name, Class<VALUETYPE> type) {
        this.name = name;
        this.type = type;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public Class<VALUETYPE> getValueType() {
        return this.type;
    }

    public boolean isEnabled() {
        return (Boolean)Callables.call(this.enabled);
    }

    public boolean isRequired() {
        return (Boolean)Callables.call(this.required);
    }

    public IMPLTYPE setEnabled(boolean enabled) {
        this.enabled = Callables.returning((Object)enabled);
        return (IMPLTYPE)((Object)this);
    }

    public IMPLTYPE setEnabled(Callable<Boolean> callback) {
        this.enabled = callback;
        return (IMPLTYPE)((Object)this);
    }

    public IMPLTYPE setLabel(String label) {
        this.label = label;
        return (IMPLTYPE)((Object)this);
    }

    public IMPLTYPE setRequired(boolean required) {
        this.required = Callables.returning((Object)required);
        return (IMPLTYPE)((Object)this);
    }

    public IMPLTYPE setRequired(Callable<Boolean> required) {
        this.required = required;
        return (IMPLTYPE)((Object)this);
    }

    public boolean supports(HintsFacet type) {
        return true;
    }

    public String getRequiredMessage() {
        return this.requiredMessage;
    }

    public IMPLTYPE setRequiredMessage(String requiredMessage) {
        this.requiredMessage = requiredMessage;
        return (IMPLTYPE)((Object)this);
    }

    public Converter<String, VALUETYPE> getValueConverter() {
        return this.valueConverter;
    }

    public IMPLTYPE setValueConverter(Converter<String, VALUETYPE> converter) {
        this.valueConverter = converter;
        return (IMPLTYPE)((Object)this);
    }
}

