/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.ui.impl;

import java.util.concurrent.Callable;
import javax.enterprise.inject.Vetoed;
import org.jboss.forge.container.util.Callables;
import org.jboss.forge.convert.Converter;
import org.jboss.forge.ui.impl.NoopCompleter;
import org.jboss.forge.ui.impl.UIInputComponentBase;
import org.jboss.forge.ui.input.UICompleter;
import org.jboss.forge.ui.input.UIInput;

@Vetoed
public class UIInputImpl<VALUETYPE>
extends UIInputComponentBase<UIInput<VALUETYPE>, VALUETYPE>
implements UIInput<VALUETYPE> {
    private VALUETYPE value;
    private Callable<VALUETYPE> defaultValue;
    private UICompleter<VALUETYPE> completer;
    private Converter<String, VALUETYPE> converter;

    public UIInputImpl(String name, Class<VALUETYPE> type) {
        super(name, type);
    }

    public UICompleter<VALUETYPE> getCompleter() {
        return this.completer == null ? new NoopCompleter() : this.completer;
    }

    public UIInput<VALUETYPE> setCompleter(UICompleter<VALUETYPE> completer) {
        this.completer = completer;
        return this;
    }

    public UIInput<VALUETYPE> setValue(VALUETYPE value) {
        this.value = value;
        return this;
    }

    public UIInput<VALUETYPE> setDefaultValue(Callable<VALUETYPE> callback) {
        this.defaultValue = callback;
        return this;
    }

    public UIInput<VALUETYPE> setDefaultValue(VALUETYPE value) {
        this.defaultValue = Callables.returning(value);
        return this;
    }

    public VALUETYPE getValue() {
        return (VALUETYPE)(this.value == null ? Callables.call(this.defaultValue) : this.value);
    }

    @Override
    public Converter<String, VALUETYPE> getValueConverter() {
        return this.converter;
    }

    @Override
    public UIInput<VALUETYPE> setValueConverter(Converter<String, VALUETYPE> converter) {
        this.converter = converter;
        return this;
    }
}

