/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.j2ssh.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AuthorizeConfiguration
extends DefaultHandler {
    private List keys = new ArrayList();
    private static Logger log = Logger.getLogger(AuthorizeConfiguration.class);
    private String currentElement = null;

    public AuthorizeConfiguration(InputStream in) throws SAXException, ParserConfigurationException, IOException {
        this.reload(in);
    }

    public void reload(InputStream in) throws SAXException, ParserConfigurationException, IOException {
        this.keys.clear();
        this.currentElement = null;
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        SAXParser saxParser = saxFactory.newSAXParser();
        saxParser.parse(in, (DefaultHandler)this);
    }

    public void startElement(String uri, String localName, String qname, Attributes attrs) throws SAXException {
        if (this.currentElement == null) {
            if (!qname.equals("AuthorizedKeys")) {
                throw new SAXException("Unexpected root element " + qname);
            }
        } else if (this.currentElement.equals("AuthorizedKeys") && !qname.equals("Key")) {
            throw new SAXException("Unexpected <" + qname + "> element after SshAPIConfiguration");
        }
        this.currentElement = qname;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String value = new String(ch, start, length);
        if (this.currentElement != null && this.currentElement.equals("Key") && !this.keys.contains(value)) {
            this.keys.add(value);
            log.debug((Object)("Keys=" + value));
        }
    }

    public void endElement(String uri, String localName, String qname) throws SAXException {
        if (this.currentElement != null) {
            if (!this.currentElement.equals(qname)) {
                throw new SAXException("Unexpected end element found <" + qname + ">");
            }
            if (this.currentElement.equals("AuthorizedKeys")) {
                this.currentElement = null;
            } else if (this.currentElement.equals("Key")) {
                this.currentElement = "AuthorizedKeys";
            }
        } else {
            throw new SAXException("Unexpected end element <" + qname + "> found");
        }
    }

    public List getKeys() {
        return this.keys;
    }

    public String toString() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        xml = xml + "<!-- Sshtools Cp2User authorization File -->\n";
        xml = xml + "<AuthorizedKeys>\n";
        Iterator it = this.keys.iterator();
        xml = xml + "   <!-- Enter authorized public key elements here -->\n";
        while (it.hasNext()) {
            xml = xml + "   <key>" + it.next().toString() + "</key>\n";
        }
        xml = xml + "</AuthorizedKeys>";
        return xml;
    }
}

