/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.ssh;

import com.sshtools.daemon.platform.InvalidHandleException;
import com.sshtools.daemon.platform.NativeFileSystemProvider;
import com.sshtools.daemon.platform.PermissionDeniedException;
import com.sshtools.daemon.platform.UnsupportedFileOperationException;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.io.UnsignedInteger64;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.SftpFile;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.fresh.registry.RegistryContext;
import org.jboss.fresh.shell.SystemShell;
import org.jboss.fresh.vfs.FileInfo;
import org.jboss.fresh.vfs.FileName;
import org.jboss.fresh.vfs.FileOpInfo;
import org.jboss.fresh.vfs.FileReadInfo;
import org.jboss.fresh.vfs.VFS;
import org.jboss.fresh.vfs.VFSException;

public class Cp2VFSProvider
extends NativeFileSystemProvider {
    private static final Logger log = Logger.getLogger(Cp2VFSProvider.class);
    private int fileid = 1;
    private DecimalFormat fmt;
    HashMap openfiles = new HashMap();
    VFS vfs;
    FileName root;

    private synchronized String getKey() {
        return this.fmt.format(this.fileid++);
    }

    public Cp2VFSProvider() {
        try {
            this.fmt = new DecimalFormat("00000000");
            RegistryContext ctx = new RegistryContext();
            SystemShell ssh = (SystemShell)ctx.lookup("java:/CP2/SystemShell");
            this.vfs = ssh.getVFS();
            log.info((Object)("Successfully initialized vfs: " + this.vfs));
            this.root = new FileName("/");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean fileExists(String path) throws IOException {
        return true;
    }

    public String getCanonicalPath(String path) throws IOException, FileNotFoundException {
        FileName fname = new FileName(path);
        return fname.toString();
    }

    public String getRealPath(String path) throws FileNotFoundException {
        FileName fname = this.root.absolutize(path);
        return fname.toString();
    }

    public boolean makeDirectory(String path) throws PermissionDeniedException, FileNotFoundException, IOException {
        return true;
    }

    public FileAttributes getFileAttributes(String path) throws IOException, FileNotFoundException {
        FileInfo inf = this.vfs.getFileInfo(null, new FileName(path), true);
        if (inf == null) {
            throw new FileNotFoundException(path);
        }
        return Cp2VFSProvider.info2Attrs(inf);
    }

    public FileAttributes getFileAttributes(byte[] handle) throws IOException, InvalidHandleException {
        String shandle = new String(handle);
        FileData data = (FileData)this.openfiles.get(shandle);
        if (data == null) {
            throw new FileNotFoundException(String.valueOf(data.name));
        }
        return Cp2VFSProvider.info2Attrs(data.info);
    }

    public byte[] openDirectory(String path) throws PermissionDeniedException, FileNotFoundException, IOException {
        byte[] key = this.getKey().getBytes();
        FileData data = new FileData();
        data.originalName = path;
        data.name = this.root.absolutize(path);
        data.info = this.vfs.getFileInfo(null, data.name, false);
        if (data.info == null) {
            throw new FileNotFoundException(String.valueOf(data.name));
        }
        this.openfiles.put(new String(key), data);
        return key;
    }

    public SftpFile[] readDirectory(byte[] handle) throws InvalidHandleException, EOFException, IOException {
        String shandle = new String(handle);
        FileData data = (FileData)this.openfiles.get(shandle);
        if (data == null) {
            throw new InvalidHandleException(shandle);
        }
        if (data.done) {
            throw new EOFException();
        }
        List ls = this.vfs.list(null, data.name, false);
        if (ls == null) {
            return null;
        }
        SftpFile[] lesfiches = new SftpFile[ls.size()];
        Iterator it = ls.iterator();
        int i = 0;
        while (it.hasNext()) {
            FileInfo finfo = (FileInfo)it.next();
            lesfiches[i] = new SftpFile(finfo.getFileName().getName(), Cp2VFSProvider.info2Attrs(finfo));
            ++i;
        }
        data.done = true;
        return lesfiches;
    }

    public byte[] openFile(String path, UnsignedInteger32 flags, FileAttributes attrs) throws PermissionDeniedException, FileNotFoundException, IOException {
        byte[] key = this.getKey().getBytes();
        try {
            FileData data = new FileData();
            data.originalName = path;
            data.name = new FileName(path);
            data.info = this.vfs.getFileInfo(null, data.name, false);
            if ((flags.intValue() & 1) == 1) {
                if (data.info == null) {
                    throw new FileNotFoundException(String.valueOf(data.name));
                }
            } else if (data.info == null) {
                FileInfo finf = new FileInfo(data.name, 1);
                finf.setMime("x-application/octet-stream");
                Date date = new Date();
                finf.setCreateDate(date);
                finf.setLastModified(date);
                String tag = this.vfs.createFile(null, finf);
                finf.setTag(tag);
                data.info = finf;
            }
            this.openfiles.put(new String(key), data);
        }
        catch (VFSException ex) {
            if (ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            IOException e = new IOException("Operation failed");
            e.initCause(ex);
            throw e;
        }
        return key;
    }

    public byte[] readFile(byte[] handle, UnsignedInteger64 offset, UnsignedInteger32 len) throws InvalidHandleException, EOFException, IOException {
        String shandle = new String(handle);
        long loffset = offset.longValue();
        int ilen = len.intValue();
        FileData data = (FileData)this.openfiles.get(shandle);
        if (data == null) {
            throw new InvalidHandleException(shandle);
        }
        if (data.done) {
            throw new EOFException();
        }
        FileOpInfo op = new FileOpInfo();
        op.filename = data.name;
        op.offset = loffset;
        op.tag = data.info.getTag();
        FileReadInfo read = this.vfs.read(null, op);
        if (read == null) {
            throw new EOFException();
        }
        if (read.buf.length > ilen) {
            byte[] buf = new byte[ilen];
            System.arraycopy(read.buf, 0, buf, 0, ilen);
        }
        if (loffset + (long)ilen >= data.info.getLength()) {
            data.done = true;
        }
        return read.buf;
    }

    public void writeFile(byte[] handle, UnsignedInteger64 offset, byte[] data, int off, int len) throws InvalidHandleException, IOException {
        String shandle = new String(handle);
        FileData dat = (FileData)this.openfiles.get(shandle);
        if (dat == null) {
            throw new InvalidHandleException(shandle);
        }
        FileOpInfo op = new FileOpInfo();
        op.filename = dat.name;
        op.offset = offset.longValue();
        op.tag = dat.info.getTag();
        byte[] buf = null;
        if (off == 0 && len == data.length) {
            buf = data;
        } else {
            buf = new byte[len];
            System.arraycopy(data, off, buf, 0, len);
        }
        op.buf = buf;
        try {
            this.vfs.write(null, op);
        }
        catch (VFSException ex) {
            if (ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            IOException iox = new IOException();
            iox.initCause(ex);
            throw iox;
        }
    }

    public void closeFile(byte[] handle) throws InvalidHandleException, IOException {
    }

    public void removeFile(String path) throws PermissionDeniedException, IOException, FileNotFoundException {
    }

    public void renameFile(String oldpath, String newpath) throws PermissionDeniedException, FileNotFoundException, IOException {
    }

    public void removeDirectory(String path) throws PermissionDeniedException, FileNotFoundException, IOException {
    }

    public void setFileAttributes(String path, FileAttributes attrs) throws PermissionDeniedException, IOException, FileNotFoundException {
    }

    public void setFileAttributes(byte[] handle, FileAttributes attrs) throws PermissionDeniedException, IOException, InvalidHandleException {
    }

    public SftpFile readSymbolicLink(String path) throws UnsupportedFileOperationException, FileNotFoundException, IOException, PermissionDeniedException {
        SftpFile file = new SftpFile("/hokuspokus3");
        return file;
    }

    public void createSymbolicLink(String link, String target) throws UnsupportedFileOperationException, FileNotFoundException, IOException, PermissionDeniedException {
    }

    public String getDefaultPath(String username) {
        return "/";
    }

    public void verifyPermissions(String username, String path, String permissions) throws PermissionDeniedException, FileNotFoundException, IOException {
    }

    static FileAttributes info2Attrs(FileInfo inf) {
        FileAttributes attrs = new FileAttributes();
        attrs.setSize(new UnsignedInteger64(String.valueOf(inf.getLength())));
        attrs.setPermissionsFromMaskString("0777");
        long perms = attrs.getPermissions().longValue();
        if (inf.isFile()) {
            perms |= 0x8000L;
        } else if (inf.isDirectory()) {
            perms |= 0x4000L;
        } else if (inf.isLink()) {
            perms |= 0xA000L;
        }
        attrs.setPermissions(new UnsignedInteger32(String.valueOf(perms)));
        UnsignedInteger32 time = new UnsignedInteger32(String.valueOf(inf.getLastModified().getTime() / 1000L));
        attrs.setTimes(time, time);
        return attrs;
    }

    static class FileData {
        String originalName;
        FileName name;
        FileInfo info;
        boolean done;

        FileData() {
        }
    }
}

