/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.ssh;

import com.sshtools.daemon.configuration.ServerConfiguration;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.fresh.io.IOUtils;
import org.jboss.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FreshServerConfiguration
extends ServerConfiguration {
    private static final Logger log = Logger.getLogger(FreshServerConfiguration.class);
    private String currentElement;
    private Map<String, SshPrivateKey> serverKeys;

    public FreshServerConfiguration(InputStream in) throws SAXException, ParserConfigurationException, IOException {
        super(in);
    }

    public void startElement(String uri, String localName, String qname, Attributes attrs) throws SAXException {
        block10: {
            if (this.currentElement != null) {
                if (this.currentElement.equals("ServerConfiguration")) {
                    if (qname.equals("ServerHostKey")) {
                        String privateKey = attrs.getValue("PrivateKeyFile");
                        if (privateKey == null) {
                            throw new SAXException("Required attributes missing from <ServerHostKey> element");
                        }
                        log.debug((Object)("ServerHostKey PrivateKeyFile=" + privateKey));
                        try {
                            InputStream keyStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(privateKey);
                            if (keyStream != null) {
                                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                IOUtils.copy((InputStream)keyStream, (OutputStream)baos);
                                byte[] keyBytes = baos.toByteArray();
                                keyStream.close();
                                baos.close();
                                SshPrivateKeyFile pkf = SshPrivateKeyFile.parse((byte[])keyBytes);
                                SshPrivateKey key = pkf.toPrivateKey(null);
                                this.serverKeys.put(key.getAlgorithmName(), key);
                                break block10;
                            }
                            log.warn((Object)("Private key file '" + privateKey + "' could not be found"));
                        }
                        catch (InvalidSshKeyException ex) {
                            log.warn((Object)("Failed to load private key '" + privateKey), (Throwable)ex);
                        }
                        catch (IOException ioe) {
                            log.warn((Object)("Failed to load private key '" + privateKey), (Throwable)ioe);
                        }
                    } else {
                        super.startElement(uri, localName, qname, attrs);
                    }
                }
            } else {
                super.startElement(uri, localName, qname, attrs);
            }
        }
        this.currentElement = qname;
    }

    public void endElement(String uri, String localName, String qname) throws SAXException {
        if (this.currentElement != null) {
            if (!this.currentElement.endsWith("ServerHostKey")) {
                super.endElement(uri, localName, qname);
            }
            this.currentElement = null;
        }
    }

    public void reload(InputStream in) throws SAXException, ParserConfigurationException, IOException {
        this.serverKeys = new HashMap<String, SshPrivateKey>();
        super.reload(in);
        this.currentElement = null;
    }

    public Map getServerHostKeys() {
        return this.serverKeys;
    }
}

