/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.ssh;

import com.sshtools.common.automate.AutomationConfiguration;
import com.sshtools.j2ssh.configuration.ConfigurationContext;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.SshAPIConfiguration;
import java.util.HashMap;
import org.jboss.logging.Logger;

public class FreshXmlConfigurationContext
implements ConfigurationContext {
    private static final Logger log = Logger.getLogger(FreshXmlConfigurationContext.class);
    HashMap<Class, Object> configurations = new HashMap();
    String apiResource = "sshtools.xml";
    String automationResource = "automation.xml";
    private boolean failOnError = false;

    public void setAPIConfigurationResource(String apiResource) {
        this.apiResource = apiResource;
    }

    public void setAutomationConfigurationResource(String automationResource) {
        this.automationResource = automationResource;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void initialize() throws ConfigurationException {
        if (this.apiResource != null) {
            try {
                com.sshtools.common.configuration.SshAPIConfiguration x = new com.sshtools.common.configuration.SshAPIConfiguration(Thread.currentThread().getContextClassLoader().getResourceAsStream(this.apiResource));
                this.configurations.put(SshAPIConfiguration.class, x);
            }
            catch (Exception ex) {
                if (this.failOnError) {
                    throw new ConfigurationException(ex.getMessage());
                }
                log.info((Object)(this.apiResource + " could not be found: " + ex.getMessage()));
            }
        }
        if (this.automationResource != null) {
            try {
                AutomationConfiguration y = new AutomationConfiguration(Thread.currentThread().getContextClassLoader().getResourceAsStream(this.automationResource));
                this.configurations.put(AutomationConfiguration.class, y);
            }
            catch (Exception ex) {
                if (this.failOnError) {
                    throw new ConfigurationException(ex.getMessage());
                }
                log.info((Object)(this.automationResource + " could not be found: " + ex.getMessage()));
            }
        }
    }

    public boolean isConfigurationAvailable(Class cls) {
        return this.configurations.containsKey(cls);
    }

    public Object getConfiguration(Class cls) throws ConfigurationException {
        if (this.configurations.containsKey(cls)) {
            return this.configurations.get(cls);
        }
        throw new ConfigurationException(cls.getName() + " configuration not available");
    }
}

