/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.ssh;

import com.sshtools.daemon.configuration.PlatformConfiguration;
import com.sshtools.daemon.configuration.ServerConfiguration;
import com.sshtools.j2ssh.configuration.ConfigurationContext;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import java.util.HashMap;
import org.jboss.fresh.ssh.FreshPlatformConfiguration;
import org.jboss.fresh.ssh.FreshServerConfiguration;
import org.jboss.logging.Logger;
import org.xml.sax.helpers.DefaultHandler;

public class FreshXmlServerConfigurationContext
implements ConfigurationContext {
    private static final Logger log = Logger.getLogger(FreshXmlServerConfigurationContext.class);
    HashMap<Class, DefaultHandler> configurations = new HashMap();
    String serverResource = null;
    String platformResource = null;
    boolean failOnError = true;

    public void setServerConfigurationResource(String serverResource) {
        this.serverResource = serverResource;
    }

    public void setPlatformConfigurationResource(String platformResource) {
        this.platformResource = platformResource;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void initialize() throws ConfigurationException {
        block7: {
            block6: {
                if (this.serverResource != null) {
                    try {
                        FreshServerConfiguration y = new FreshServerConfiguration(Thread.currentThread().getContextClassLoader().getResourceAsStream(this.serverResource));
                        this.configurations.put(ServerConfiguration.class, (DefaultHandler)((Object)y));
                    }
                    catch (Exception ex) {
                        log.error((Object)"could not init server configuration ", (Throwable)ex);
                        if (!this.failOnError) break block6;
                        throw new ConfigurationException(ex.getMessage());
                    }
                }
            }
            if (this.platformResource != null) {
                try {
                    FreshPlatformConfiguration z = new FreshPlatformConfiguration(Thread.currentThread().getContextClassLoader().getResourceAsStream(this.platformResource));
                    this.configurations.put(PlatformConfiguration.class, (DefaultHandler)((Object)z));
                }
                catch (Exception ex) {
                    if (!this.failOnError) break block7;
                    throw new ConfigurationException(ex.getMessage());
                }
            }
        }
    }

    public boolean isConfigurationAvailable(Class cls) {
        return this.configurations.containsKey(cls);
    }

    public Object getConfiguration(Class cls) throws ConfigurationException {
        if (this.configurations.containsKey(cls)) {
            return this.configurations.get(cls);
        }
        throw new ConfigurationException(cls.getName() + " configuration not available");
    }
}

