/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.ssh;

import com.sshtools.daemon.platform.NativeProcessProvider;
import com.sshtools.j2ssh.SshThread;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.jboss.fresh.cpii.services.PoolRunner;
import org.jboss.fresh.io.Buffer;
import org.jboss.fresh.io.BufferInputStream;
import org.jboss.fresh.io.EOLFixInputStream;
import org.jboss.fresh.io.InBuffer;
import org.jboss.fresh.io.PrintWriter2;
import org.jboss.fresh.registry.RegistryContext;
import org.jboss.fresh.shell.ProcessInfo;
import org.jboss.fresh.shell.SessionTimeoutException;
import org.jboss.fresh.shell.ShellException;
import org.jboss.fresh.shell.ShellOutputStream;
import org.jboss.fresh.shell.ShellStreamer;
import org.jboss.fresh.shell.SystemShell;
import org.jboss.fresh.shell.impl.ShellImpl;
import org.jboss.fresh.util.StringUtils;

public class SSHShell
extends NativeProcessProvider {
    static final int SHELL_MODE = 0;
    static final int PROCESS_MODE = 1;
    static final int OVERWRITE = 0;
    static final int INSERT = 1;
    private static String ssjndi = "java:/FRESH/SystemShell";
    private static String homeDir = "../fresh/users";
    private static int MAX_HISTORY_SIZE = 200;
    static final Logger log = Logger.getLogger(SSHShell.class);
    int mode = 0;
    boolean mustExit = false;
    int insMode = 1;
    Throwable lastError;
    LineEditor editor;
    InMasterOutputStream masterIn;
    OutMasterInputStream masterOut;
    StdErrorInputStream stdErr;
    ShellImpl shell;
    ProcessInfo iproc;
    String user = "unknown";
    String host = "localhost";
    int screen_rows;
    int screen_cols;
    SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");

    public static void setSystemShellJNDI(String name) {
        ssjndi = name;
    }

    public SSHShell() {
        try {
            this.user = SshThread.getCurrentThread().getUsername();
        }
        catch (Throwable th) {
            log.error((Object)"Failed to retrieve username: ", th);
        }
        try {
            this.host = InetAddress.getLocalHost().getHostName();
            int dot = this.host.indexOf(".");
            if (dot != -1) {
                this.host = this.host.substring(0, dot);
            }
        }
        catch (UnknownHostException ex) {
            log.error((Object)"Failed to retrieve hostname: ", (Throwable)ex);
        }
        StringBuffer errMessage = new StringBuffer();
        try {
            RegistryContext ctx = new RegistryContext();
            SystemShell ssh = (SystemShell)ctx.lookup(ssjndi);
            this.shell = (ShellImpl)ssh.startSession(null, false);
            try {
                this.shell.executeAsObject("cd /");
            }
            catch (ShellException ex) {
                log.warn((Object)"Error while setting current dir to /: ", (Throwable)ex);
                errMessage.append("Failed to set current dir to /\r\n");
            }
            File profile = this.getHomeFile(".profile");
            try {
                if (profile != null) {
                    this.shell.executeAsObject("exec --ex &< " + profile.getAbsolutePath());
                }
            }
            catch (ShellException e) {
                log.warn((Object)("Error while executing .profile: " + profile), (Throwable)e);
                errMessage.append("Failed to execute .profile\r\n");
            }
            log.info((Object)("Successfully initialized shell: " + this.shell));
        }
        catch (NamingException e) {
            log.error((Object)"Exception while initializin SSHShell: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (ShellException e) {
            log.error((Object)"Exception while initializin SSHShell: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.masterIn = new InMasterOutputStream();
        this.masterOut = new OutMasterInputStream();
        this.stdErr = new StdErrorInputStream();
        this.editor = new LineEditor();
        if (errMessage.length() > 0) {
            this.masterOut.addBytes(errMessage.toString().getBytes());
        }
    }

    public File getHomeFile(String fname) {
        File tfile;
        File userDir;
        String hUser = this.user;
        if (hUser == null || hUser.length() == 0) {
            hUser = "root";
        }
        if (!(userDir = new File(homeDir, hUser)).isDirectory() && !userDir.mkdirs()) {
            log.warn((Object)("Home directory for user " + this.user + " does not exist and could not be created."));
        }
        if (userDir.isDirectory() && (tfile = new File(userDir, fname)).isFile()) {
            return tfile;
        }
        return null;
    }

    public InputStream getInputStream() throws IOException {
        return this.masterOut;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.masterIn;
    }

    public InputStream getStderrInputStream() throws IOException {
        return this.stdErr;
    }

    public void kill() {
        log.info((Object)"####  kill called");
        this.closeShell();
    }

    public boolean stillActive() {
        log.debug((Object)("stillActive ? " + (!this.mustExit && !this.masterOut.isClosed())));
        return !this.mustExit && !this.masterOut.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForExitCode() {
        SSHShell sSHShell = this;
        synchronized (sSHShell) {
            while (this.stillActive()) {
                try {
                    log.debug((Object)"Exit WAIT");
                    ((Object)((Object)this)).wait();
                    log.debug((Object)"Exit WAKEUP");
                }
                catch (InterruptedException ex) {
                    log.info((Object)"ExitCode 1");
                    return 1;
                }
            }
            log.info((Object)"ExitCode 0");
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeShell() {
        this.mustExit = true;
        if (this.masterOut != null) {
            this.masterOut.close();
        }
        if (this.stdErr != null) {
            this.stdErr.close();
        }
        SSHShell sSHShell = this;
        synchronized (sSHShell) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    public String getDefaultTerminalProvider() {
        return "VT320";
    }

    public boolean createProcess(String command, Map environment) throws IOException {
        return true;
    }

    public void start() throws IOException {
    }

    public boolean supportsPseudoTerminal(String term) {
        return true;
    }

    public boolean allocatePseudoTerminal(String term, int cols, int rows, int width, int height, String modes) {
        this.setTerminalDimensions(cols, rows, width, height);
        return true;
    }

    public void setTerminalDimensions(int cols, int rows, int width, int height) {
        this.screen_rows = rows;
        this.screen_cols = cols;
        if (this.shell != null) {
            try {
                this.shell.setEnvProperty("SCREEN_ROWS", String.valueOf(this.screen_rows));
                this.shell.setEnvProperty("SCREEN_COLS", String.valueOf(this.screen_cols));
            }
            catch (Exception ex) {
                log.warn((Object)"Failed to set new screen size to shell's ENV: ", (Throwable)ex);
            }
        }
    }

    public InputStream getProcessInputStream() {
        log.debug((Object)"getProcessInputStream called");
        return null;
    }

    public OutputStream getProcessOutputStream() {
        log.debug((Object)"getProcessOutputStream called");
        return null;
    }

    void prompt() {
        StringBuffer prompt = new StringBuffer();
        if (this.masterOut.lastChar != 10) {
            prompt.append("\r\n");
            this.masterOut.lastChar = 0;
        }
        prompt.append("[").append(this.sdf.format(new Date())).append("] ").append(this.user).append("@").append(this.host).append(" ");
        String fullname = "#err#";
        try {
            fullname = this.shell.getEnvProperty("PWD");
        }
        catch (Throwable ex) {
            log.error((Object)"Failed to get PWD:", ex);
        }
        int lidx = fullname.lastIndexOf("/");
        if (lidx != -1 && fullname.length() > 1) {
            fullname = fullname.substring(lidx + 1);
        }
        prompt.append(fullname).append(" ").append("# ");
        this.masterOut.addBytes(prompt.toString().getBytes());
    }

    void cancelProcess() {
        if (this.iproc == null) {
            return;
        }
        Buffer buf = null;
        try {
            buf = this.shell.getBuffer(this.iproc.procid, 1);
            if (buf != null) {
                buf.close();
            }
        }
        catch (Exception ex) {
            log.info((Object)("Exception while closing stdin buffer for: " + this.iproc.procid), (Throwable)ex);
        }
        try {
            buf = this.shell.getBuffer(this.iproc.procid, 2);
            if (buf != null) {
                buf.close();
            }
        }
        catch (Exception ex) {
            log.info((Object)("Exception while closing stdout buffer for: " + this.iproc.procid), (Throwable)ex);
        }
    }

    void writeError(Throwable th) {
        if (th instanceof SessionTimeoutException) {
            this.closeShell();
            return;
        }
        this.lastError = th;
        while (th.getCause() != null) {
            th = th.getCause();
        }
        this.masterOut.addBytes(th.toString().getBytes());
        this.masterOut.addBytes("\r\n".getBytes());
    }

    void writeStackTrace(Throwable th) {
        StringWriter sw = new StringWriter();
        PrintWriter2 pw = new PrintWriter2((Writer)sw);
        th.printStackTrace((PrintWriter)pw);
        pw.println();
        pw.close();
        this.masterOut.addBytes(sw.toString().getBytes());
        this.prompt();
    }

    static class StdErrorInputStream
    extends InputStream {
        boolean closed = false;

        StdErrorInputStream() {
        }

        public synchronized int read() {
            try {
                if (!this.closed) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return -1;
        }

        public synchronized int read(byte[] buf) {
            return this.read(buf, 0, buf.length);
        }

        public synchronized int read(byte[] bug, int offs, int len) {
            try {
                if (!this.closed) {
                    this.wait();
                }
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            return -1;
        }

        public int available() {
            return 0;
        }

        public synchronized void close() {
            this.closed = true;
            this.notifyAll();
        }
    }

    class OutMasterInputStream
    extends InputStream {
        boolean closed = false;
        boolean delegateMode = false;
        BufferInputStream delegate;
        InputStream delegateReal;
        int lastChar = -1;
        byte[] buff = new byte[8192];
        int offs = 0;
        int len = 0;
        boolean waiting = false;

        OutMasterInputStream() {
        }

        public void setInputStream(BufferInputStream in) {
            this.delegate = in;
            this.delegateReal = new EOLFixInputStream((InputStream)in);
            this.delegateMode = in != null;
        }

        boolean isDelegateMode() {
            return this.delegateMode;
        }

        public boolean toBufferMode() {
            boolean wasOn = this.delegateMode;
            this.delegateMode = false;
            this.delegate = null;
            this.delegateReal = null;
            SSHShell.this.prompt();
            SSHShell.this.masterIn.toBufferMode();
            return wasOn;
        }

        private void shrink() {
            if (this.len > 0 && this.len == this.offs) {
                this.offs = 0;
                this.len = 0;
            }
        }

        synchronized void addByte(int aval) {
            this.shrink();
            int togo = this.buff.length - this.len;
            if (togo > 0) {
                this.buff[this.len++] = (byte)aval;
            }
            this.notify();
        }

        void addBytes(byte[] abuf) {
            this.addBytes(abuf, 0, abuf.length);
        }

        synchronized void addBytes(byte[] abuf, int aoffs, int alen) {
            this.shrink();
            int togo = this.buff.length - this.len;
            if (togo > alen) {
                togo = alen;
            }
            System.arraycopy(abuf, aoffs, this.buff, this.len, togo);
            this.len += togo;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            log.debug((Object)"read");
            while (!this.closed) {
                OutMasterInputStream outMasterInputStream;
                if (this.delegateMode) {
                    log.debug((Object)"   --- delegateMode on");
                    outMasterInputStream = this;
                    synchronized (outMasterInputStream) {
                        if (this.offs < this.len) {
                            return this.buff[this.offs++];
                        }
                    }
                    try {
                        this.delegate.setTimeout(Integer.MAX_VALUE);
                        this.delegate.setAsyncMode(false);
                        int b = this.delegateReal.read();
                        if (b != -1) {
                            this.lastChar = b;
                            return b;
                        }
                        this.toBufferMode();
                    }
                    catch (Exception ex) {
                        SSHShell.this.writeError(ex);
                        this.toBufferMode();
                    }
                }
                outMasterInputStream = this;
                synchronized (outMasterInputStream) {
                    if (this.offs < this.len) {
                        return this.buff[this.offs++];
                    }
                    try {
                        this.waiting = true;
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        this.waiting = false;
                    }
                }
            }
            return -1;
        }

        public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] abuf, int aoffs, int alen) throws IOException {
            log.debug((Object)"read byte[]");
            while (!this.closed) {
                OutMasterInputStream outMasterInputStream;
                if (this.delegateMode) {
                    log.debug((Object)"   --- delegateMode on");
                    outMasterInputStream = this;
                    synchronized (outMasterInputStream) {
                        int togo;
                        this.shrink();
                        if (this.offs == this.len) {
                            togo = this.buff.length - this.len;
                            try {
                                this.delegate.setAsyncMode(true);
                                int rb = 0;
                                while (rb == 0) {
                                    log.debug((Object)"Delegate read");
                                    rb = this.delegateReal.read(this.buff, this.offs, togo);
                                }
                                if (rb == -1) {
                                    this.toBufferMode();
                                } else {
                                    this.len += rb;
                                    this.lastChar = this.buff[this.offs + rb - 1];
                                }
                            }
                            catch (Exception ex) {
                                SSHShell.this.writeError(ex);
                                this.toBufferMode();
                            }
                        }
                        if ((togo = this.len - this.offs) > 0) {
                            togo = togo < alen ? togo : alen;
                            System.arraycopy(this.buff, this.offs, abuf, aoffs, togo);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("read " + togo + " bytes. (" + this.offs + " : " + this.len + ") -> " + (this.offs + togo)));
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)(new String(this.buff, this.offs, togo) + " [" + StringUtils.toBytesString((String)new String(this.buff, this.offs, togo)) + "]"));
                            }
                            this.offs += togo;
                            return togo;
                        }
                    }
                }
                outMasterInputStream = this;
                synchronized (outMasterInputStream) {
                    if (this.offs < this.len) {
                        int diff = this.len - this.offs;
                        if (alen > diff) {
                            alen = diff;
                        }
                        System.arraycopy(this.buff, this.offs, abuf, aoffs, alen);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("read " + alen + " bytes. (" + this.offs + " : " + this.len + ") -> " + (this.offs + alen)));
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(new String(this.buff, this.offs, alen) + " [" + StringUtils.toBytesString((String)new String(this.buff, this.offs, alen)) + "]"));
                        }
                        this.offs += alen;
                        return alen;
                    }
                    try {
                        this.waiting = true;
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        this.waiting = false;
                    }
                }
            }
            return -1;
        }

        public int available() throws IOException {
            log.debug((Object)"available");
            if (this.closed) {
                throw new EOFException();
            }
            if (this.delegateMode) {
                log.debug((Object)"   --- delegateMode on");
                if (this.len - this.offs > 0) {
                    return this.len - this.offs;
                }
                return this.delegateReal.available();
            }
            return this.len - this.offs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitCompletion() throws IOException {
            while (this.available() > 0 || this.delegateMode) {
                try {
                    OutMasterInputStream outMasterInputStream = this;
                    synchronized (outMasterInputStream) {
                        if (this.waiting) {
                            this.notify();
                        }
                    }
                    Thread.sleep(200L);
                }
                catch (InterruptedException ex) {
                    throw (IOException)new InterruptedIOException().initCause(ex);
                }
            }
        }

        public synchronized void close() {
            this.closed = true;
            this.notifyAll();
        }

        public boolean isClosed() {
            return this.closed;
        }
    }

    class InMasterOutputStream
    extends OutputStream {
        boolean closed = false;
        boolean delegateMode = false;
        OutputStream delegate;
        long lastCheck = 0L;

        InMasterOutputStream() {
        }

        public void setOutputStream(OutputStream out) {
            this.delegate = out;
            this.delegateMode = out != null;
        }

        public boolean toBufferMode() {
            boolean wasOn = this.delegateMode;
            this.delegateMode = false;
            this.delegate = null;
            return wasOn;
        }

        public void write(int b) throws IOException {
            if (log.isDebugEnabled()) {
                log.debug((Object)("write: " + b));
            }
            if (this.closed) {
                throw new EOFException();
            }
            if (this.delegateMode) {
                log.debug((Object)"   --- delegateMode on");
                try {
                    if (b == 3) {
                        this.delegate.close();
                        SSHShell.this.cancelProcess();
                        this.toBufferMode();
                        return;
                    }
                    this.delegate.write(b);
                }
                catch (EOFException ex) {
                    this.toBufferMode();
                }
                catch (Throwable ex) {
                    SSHShell.this.writeError(ex);
                }
                return;
            }
            this.checkLastUsed();
            SSHShell.this.editor.addByte(b);
        }

        public void write(byte[] buf) throws IOException {
            this.write(buf, 0, buf.length);
        }

        public void write(byte[] buf, int offs, int len) throws IOException {
            if (log.isDebugEnabled()) {
                log.debug((Object)("write: " + new String(buf, offs, len)));
            }
            if (this.closed) {
                throw new EOFException();
            }
            if (this.delegateMode) {
                log.debug((Object)"   --- delegateMode on");
                try {
                    for (int i = 0; i < len; ++i) {
                        if (buf[i + offs] != 3) continue;
                        if (i > 0) {
                            this.delegate.write(buf, offs, i);
                        }
                        this.delegate.close();
                        SSHShell.this.cancelProcess();
                        this.toBufferMode();
                        return;
                    }
                    this.delegate.write(buf, offs, len);
                }
                catch (EOFException ex) {
                    this.toBufferMode();
                }
                catch (Throwable ex) {
                    SSHShell.this.writeError(ex);
                }
                return;
            }
            this.checkLastUsed();
            SSHShell.this.editor.addBytes(buf, offs, len);
        }

        public void flush() throws IOException {
            log.debug((Object)"flush");
            if (this.delegateMode) {
                log.debug((Object)"   --- delegateMode on");
                try {
                    this.delegate.flush();
                }
                catch (EOFException ex) {
                    this.toBufferMode();
                }
                catch (Throwable ex) {
                    SSHShell.this.writeError(ex);
                }
            }
        }

        public void close() throws IOException {
            log.debug((Object)"close");
            if (this.closed) {
                return;
            }
            if (this.delegateMode) {
                log.debug((Object)"   --- delegateMode on");
                try {
                    this.delegate.close();
                }
                catch (EOFException ex) {
                    this.toBufferMode();
                }
                catch (Throwable ex) {
                    SSHShell.this.writeError(ex);
                }
            }
            this.closed = true;
            SSHShell.this.closeShell();
        }

        private void checkLastUsed() {
            long now = System.currentTimeMillis();
            if (now - this.lastCheck > 10000L) {
                try {
                    SSHShell.this.shell.using();
                }
                catch (Exception ex) {
                    try {
                        this.close();
                    }
                    catch (Exception e) {
                        log.warn((Object)"Exception occured while closing due to session timeout", (Throwable)e);
                    }
                }
                this.lastCheck = now;
            }
        }

        public boolean isClosed() {
            return this.closed;
        }
    }

    class LineEditor {
        ArrayList<StringBuffer> history = new ArrayList();
        HashMap<Integer, StringBuffer> activeEdit = new HashMap();
        int hidx = 0;
        StringBuffer linebuf = new StringBuffer();
        int carret = 0;
        byte[] unprocessed = new byte[5];
        int charsPos = 0;
        private String multilineEOF;
        private StringBuffer multilineBuffer;
        private boolean foundEOF;
        PoolRunner runner;
        RunnerJob rjob = new RunnerJob();
        ProcessInfo pinf;

        LineEditor() {
            File historyFile = SSHShell.this.getHomeFile(".history");
            if (historyFile != null) {
                BufferedReader rd = null;
                try {
                    LinkedList<StringBuffer> nuHistory = new LinkedList<StringBuffer>();
                    rd = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(historyFile), "UTF-8"));
                    String line = rd.readLine();
                    while (line != null) {
                        if (line.trim().length() != 0) {
                            nuHistory.add(new StringBuffer(line));
                            if (nuHistory.size() > MAX_HISTORY_SIZE) {
                                nuHistory.removeFirst();
                            }
                        }
                        line = rd.readLine();
                    }
                    this.history.addAll(nuHistory);
                }
                catch (Exception ex) {
                    log.warn((Object)"Failed to read .history file");
                }
            }
            this.addHistory(this.linebuf);
            this.hidx = this.history.size() - 1;
            SSHShell.this.prompt();
        }

        private void addHistory(StringBuffer val) {
            this.history.add(val);
            int clearSize = (int)((double)MAX_HISTORY_SIZE * 0.2);
            if (this.history.size() > MAX_HISTORY_SIZE + clearSize) {
                ArrayList<StringBuffer> nuHistory = new ArrayList<StringBuffer>(MAX_HISTORY_SIZE + clearSize + 1);
                for (int i = 0; i < MAX_HISTORY_SIZE; ++i) {
                    nuHistory.add(this.history.get(clearSize + i));
                }
                this.history = nuHistory;
            }
        }

        private void setOverwriteMode() {
            SSHShell.this.insMode = 0;
        }

        private void setInsertMode() {
            SSHShell.this.insMode = 1;
        }

        private void addChar(byte val) {
            try {
                byte[] aval = new byte[]{val};
                int diff = this.linebuf.length() - this.carret;
                if (diff > 0) {
                    if (SSHShell.this.insMode == 0) {
                        this.linebuf.setCharAt(this.carret, new String(aval, "ISO8859_1").charAt(0));
                    } else {
                        this.linebuf.insert(this.carret, new String(aval, "ISO8859_1"));
                    }
                    byte[] bcv = this.linebuf.substring(this.carret, this.linebuf.length()).getBytes("ISO8859_1");
                    byte[] bf = new byte[bcv.length - 1];
                    for (int i = 0; i < bf.length; ++i) {
                        bf[i] = 8;
                    }
                    ++this.carret;
                    SSHShell.this.masterOut.addBytes(bcv);
                    SSHShell.this.masterOut.addBytes(bf);
                } else {
                    if (SSHShell.this.insMode != 1) {
                        this.setInsertMode();
                    }
                    this.linebuf.append(new String(aval, "ISO8859_1"));
                    ++this.carret;
                    SSHShell.this.masterOut.addBytes(aval);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        private void shiftChars(int len) {
            System.arraycopy(this.unprocessed, len, this.unprocessed, 0, this.unprocessed.length - len);
            this.charsPos -= len;
        }

        private void processInput() {
            int i = 0;
            while (this.charsPos > i) {
                if (this.unprocessed[i] == 27) {
                    if (this.charsPos > i + 1) {
                        if (this.unprocessed[i + 1] == 91) {
                            if (this.charsPos > i + 2) {
                                if (this.unprocessed[i + 2] == 68) {
                                    this.leftArrow();
                                    this.shiftChars(3);
                                    continue;
                                }
                                if (this.unprocessed[i + 2] == 67) {
                                    this.rightArrow();
                                    this.shiftChars(3);
                                    continue;
                                }
                                if (this.unprocessed[i + 2] == 65) {
                                    this.upArrow();
                                    this.shiftChars(3);
                                    continue;
                                }
                                if (this.unprocessed[i + 2] == 66) {
                                    this.downArrow();
                                    this.shiftChars(3);
                                    continue;
                                }
                                if (this.unprocessed[i + 2] == 70) {
                                    this.end();
                                    this.shiftChars(3);
                                    continue;
                                }
                                if (this.unprocessed[i + 2] == 72) {
                                    this.home();
                                    this.shiftChars(3);
                                    continue;
                                }
                                if (this.unprocessed[i + 2] == 50) {
                                    if (this.charsPos <= i + 3) continue;
                                    this.shiftChars(4);
                                    continue;
                                }
                                if (this.unprocessed[i + 2] == 51) {
                                    if (this.charsPos > i + 3) {
                                        if (this.unprocessed[i + 3] == 126) {
                                            this.del();
                                            this.shiftChars(4);
                                            continue;
                                        }
                                        this.shiftChars(4);
                                        continue;
                                    }
                                    i += 4;
                                    continue;
                                }
                                if (this.unprocessed[i + 2] == 52) {
                                    if (this.charsPos > i + 3) {
                                        if (this.unprocessed[i + 3] == 126) {
                                            this.end();
                                            this.shiftChars(4);
                                            continue;
                                        }
                                        this.shiftChars(4);
                                        continue;
                                    }
                                    i += 4;
                                    continue;
                                }
                                if (this.unprocessed[i + 2] == 49) {
                                    if (this.charsPos > i + 3) {
                                        if (this.unprocessed[i + 3] == 126) {
                                            this.home();
                                            this.shiftChars(4);
                                            continue;
                                        }
                                        this.shiftChars(4);
                                        continue;
                                    }
                                    i += 4;
                                    continue;
                                }
                                if (this.unprocessed[i + 2] == 53) {
                                    if (this.charsPos > i + 3) {
                                        if (this.unprocessed[i + 3] == 126) {
                                            this.pgup();
                                            this.shiftChars(4);
                                            continue;
                                        }
                                        this.shiftChars(4);
                                        continue;
                                    }
                                    i += 4;
                                    continue;
                                }
                                if (this.unprocessed[i + 2] == 54) {
                                    if (this.charsPos > i + 3) {
                                        if (this.unprocessed[i + 3] == 126) {
                                            this.pgdown();
                                            this.shiftChars(4);
                                            continue;
                                        }
                                        this.shiftChars(4);
                                        continue;
                                    }
                                    i += 4;
                                    continue;
                                }
                                i += 3;
                                continue;
                            }
                            i += 2;
                            continue;
                        }
                        if (this.unprocessed[i + 1] == 79) {
                            this.shiftChars(2);
                            continue;
                        }
                        this.shiftChars(2);
                        continue;
                    }
                    ++i;
                    continue;
                }
                if (this.unprocessed[i] == 127) {
                    this.backspace();
                    this.shiftChars(1);
                    continue;
                }
                if (this.unprocessed[i] == 13) {
                    this.shiftChars(1);
                    this.ret();
                    continue;
                }
                if (this.unprocessed[i] == 8) {
                    this.setOverwriteMode();
                    this.leftArrow();
                    this.shiftChars(1);
                    continue;
                }
                if (this.unprocessed[i] == 4) {
                    this.shiftChars(1);
                    this.foundEOF = true;
                    this.ret();
                    continue;
                }
                log.debug((Object)("char: " + this.unprocessed[i]));
                this.addChar(this.unprocessed[i]);
                this.shiftChars(1);
            }
        }

        void leftArrow() {
            if (this.carret > 0) {
                --this.carret;
                SSHShell.this.masterOut.addByte(8);
            } else {
                SSHShell.this.masterOut.addByte(7);
            }
        }

        void rightArrow() {
            if (this.carret < this.linebuf.length()) {
                try {
                    SSHShell.this.masterOut.addBytes(String.valueOf(this.linebuf.charAt(this.carret++)).getBytes("ISO8859_1"));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                SSHShell.this.masterOut.addByte(7);
            }
        }

        void upArrow() {
            int i;
            StringBuffer prev;
            if (this.hidx == 0) {
                return;
            }
            if (this.hidx < this.history.size() - 1) {
                this.activeEdit.put(new Integer(this.hidx), this.linebuf);
            }
            --this.hidx;
            if (this.hidx >= this.history.size()) {
                this.hidx = this.history.size() - 1;
            }
            if ((prev = this.activeEdit.get(new Integer(this.hidx))) == null) {
                prev = new StringBuffer(this.history.get(this.hidx).toString());
            }
            byte[] buf = new byte[this.carret + 3 + prev.length()];
            for (i = 0; i < this.carret; ++i) {
                buf[i] = 8;
            }
            buf[i++] = 27;
            buf[i++] = 91;
            buf[i++] = 75;
            this.linebuf = prev;
            try {
                System.arraycopy(this.linebuf.toString().getBytes("ISO8859_1"), 0, buf, i, this.linebuf.length());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.carret = this.linebuf.length();
            SSHShell.this.masterOut.addBytes(buf);
            SSHShell.this.masterOut.addBytes(new byte[]{27, 91, 75});
            SSHShell.this.masterOut.addBytes(new byte[]{27, 91, 74});
        }

        void downArrow() {
            int i;
            if (this.hidx >= this.history.size() - 1) {
                return;
            }
            this.activeEdit.put(new Integer(this.hidx), this.linebuf);
            ++this.hidx;
            StringBuffer next = null;
            if (this.hidx == this.history.size() - 1) {
                next = this.history.get(this.hidx);
            } else {
                next = this.activeEdit.get(new Integer(this.hidx));
                if (next == null) {
                    next = new StringBuffer(this.history.get(this.hidx).toString());
                }
            }
            byte[] buf = new byte[this.carret + 3 + next.length()];
            for (i = 0; i < this.carret; ++i) {
                buf[i] = 8;
            }
            buf[i++] = 27;
            buf[i++] = 91;
            buf[i++] = 75;
            this.linebuf = next;
            try {
                System.arraycopy(this.linebuf.toString().getBytes("ISO8859_1"), 0, buf, i, this.linebuf.length());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.carret = this.linebuf.length();
            SSHShell.this.masterOut.addBytes(buf);
            SSHShell.this.masterOut.addBytes(new byte[]{27, 91, 75});
            SSHShell.this.masterOut.addBytes(new byte[]{27, 91, 74});
        }

        void pgup() {
            int i;
            if (this.hidx == 0) {
                return;
            }
            if (this.hidx < this.history.size() - 1) {
                this.activeEdit.put(new Integer(this.hidx), this.linebuf);
            }
            this.hidx = 0;
            StringBuffer prev = this.activeEdit.get(new Integer(this.hidx));
            if (prev == null) {
                prev = new StringBuffer(this.history.get(this.hidx).toString());
            }
            byte[] buf = new byte[this.carret + 3 + prev.length()];
            for (i = 0; i < this.carret; ++i) {
                buf[i] = 8;
            }
            buf[i++] = 27;
            buf[i++] = 91;
            buf[i++] = 75;
            this.linebuf = prev;
            try {
                System.arraycopy(this.linebuf.toString().getBytes("ISO8859_1"), 0, buf, i, this.linebuf.length());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.carret = this.linebuf.length();
            SSHShell.this.masterOut.addBytes(buf);
        }

        void pgdown() {
            int i;
            if (this.hidx >= this.history.size() - 1) {
                return;
            }
            this.activeEdit.put(new Integer(this.hidx), this.linebuf);
            this.hidx = this.history.size() - 1;
            StringBuffer next = null;
            if (this.hidx == this.history.size() - 1) {
                next = this.history.get(this.hidx);
            } else {
                next = this.activeEdit.get(new Integer(this.hidx));
                if (next == null) {
                    next = new StringBuffer(this.history.get(this.hidx).toString());
                }
            }
            byte[] buf = new byte[this.carret + 3 + next.length()];
            for (i = 0; i < this.carret; ++i) {
                buf[i] = 8;
            }
            buf[i++] = 27;
            buf[i++] = 91;
            buf[i++] = 75;
            this.linebuf = next;
            try {
                System.arraycopy(this.linebuf.toString().getBytes("ISO8859_1"), 0, buf, i, this.linebuf.length());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.carret = this.linebuf.length();
            SSHShell.this.masterOut.addBytes(buf);
        }

        void end() {
            int ocarret = this.carret;
            this.carret = this.linebuf.length();
            try {
                SSHShell.this.masterOut.addBytes(this.linebuf.substring(ocarret, this.carret).getBytes("ISO8859_1"));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        void home() {
            byte[] buf = new byte[this.carret];
            for (int i = 0; i < this.carret; ++i) {
                buf[i] = 8;
            }
            this.carret = 0;
            SSHShell.this.masterOut.addBytes(buf);
        }

        void backspace() {
            if (this.carret == 0) {
                return;
            }
            int diff = this.linebuf.length() - this.carret;
            byte[] buf = new byte[diff * 2 + 4];
            buf[0] = 8;
            try {
                System.arraycopy(this.linebuf.substring(this.carret).getBytes("ISO8859_1"), 0, buf, 1, diff);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            buf[diff + 1] = 27;
            buf[diff + 2] = 91;
            buf[diff + 3] = 75;
            for (int i = diff + 4; i < buf.length; ++i) {
                buf[i] = 8;
            }
            --this.carret;
            this.linebuf.deleteCharAt(this.carret);
            SSHShell.this.masterOut.addBytes(buf);
        }

        void del() {
            if (this.carret == this.linebuf.length()) {
                return;
            }
            this.linebuf.deleteCharAt(this.carret);
            int diff = this.linebuf.length() - this.carret;
            byte[] buf = new byte[diff * 2 + 3];
            try {
                System.arraycopy(this.linebuf.substring(this.carret).getBytes("ISO8859_1"), 0, buf, 0, diff);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            buf[diff] = 27;
            buf[diff + 1] = 91;
            buf[diff + 2] = 75;
            for (int i = diff + 3; i < buf.length; ++i) {
                buf[i] = 8;
            }
            SSHShell.this.masterOut.addBytes(buf);
        }

        void ret() {
            this.end();
            boolean multiLineFinished = false;
            boolean multiLineStarted = false;
            String cmd = this.linebuf.toString().trim();
            if (this.multilineEOF != null) {
                if (cmd.equals(this.multilineEOF)) {
                    multiLineFinished = true;
                    cmd = this.multilineBuffer.toString();
                } else if (this.foundEOF) {
                    this.foundEOF = false;
                    multiLineFinished = true;
                    this.multilineBuffer.append(cmd);
                    cmd = this.multilineBuffer.toString();
                } else {
                    this.multilineBuffer.append(cmd).append("\r\n");
                }
            } else {
                this.multilineEOF = this.checkMultiline(cmd);
                if (this.multilineEOF != null) {
                    multiLineStarted = true;
                    this.multilineBuffer = new StringBuffer(cmd).append("\r\n");
                }
            }
            if (this.hidx != this.history.size() - 1) {
                StringBuffer sb = this.history.get(this.history.size() - 1);
                sb.setLength(0);
                sb.append(this.linebuf);
            }
            if (this.multilineEOF == null || multiLineStarted) {
                if (this.history.size() > 1 && cmd.equals(this.history.get(this.history.size() - 2).toString()) || "".equals(cmd)) {
                    this.history.remove(this.history.size() - 1);
                } else {
                    this.logHistory(cmd);
                }
                this.linebuf = new StringBuffer();
                this.addHistory(this.linebuf);
                this.hidx = this.history.size() - 1;
            } else {
                this.linebuf = new StringBuffer();
            }
            this.activeEdit.clear();
            this.carret = 0;
            SSHShell.this.masterOut.addBytes(new byte[]{27, 91, 75});
            SSHShell.this.masterOut.addBytes(new byte[]{27, 91, 74});
            SSHShell.this.masterOut.addBytes(new byte[]{13, 10});
            SSHShell.this.masterOut.lastChar = 10;
            if (this.multilineEOF == null) {
                if ("exit".equals(cmd)) {
                    SSHShell.this.closeShell();
                    return;
                }
                if ("err".equals(cmd)) {
                    if (SSHShell.this.lastError != null) {
                        SSHShell.this.writeStackTrace(SSHShell.this.lastError);
                    }
                    return;
                }
            }
            if (this.multilineEOF == null || multiLineFinished) {
                this.multilineEOF = null;
                log.debug((Object)("call processCommand: " + cmd));
                try {
                    this.processCommand(cmd);
                    log.debug((Object)("done calling: " + cmd));
                }
                catch (Throwable th) {
                    SSHShell.this.writeError(th);
                    SSHShell.this.prompt();
                }
            } else {
                this.printNewLinePrompt(SSHShell.this.masterOut);
            }
        }

        private String checkMultiline(String cmd) {
            int pos = cmd.lastIndexOf("<<");
            if (pos == -1) {
                return null;
            }
            String ending = cmd.substring(pos + 2).trim();
            if (ending.indexOf("\"") != -1 || ending.indexOf("'") != -1) {
                return null;
            }
            return ending;
        }

        private void printNewLinePrompt(OutMasterInputStream masterOut) {
            masterOut.addBytes(new byte[]{62, 32});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void logHistory(String cmd) {
            RandomAccessFile raf;
            block16: {
                if ("exit".trim().equals(cmd)) {
                    return;
                }
                String hUser = SSHShell.this.user;
                if (hUser == null || hUser.length() == 0) {
                    hUser = "root";
                }
                File userDir = new File(homeDir, hUser);
                File historyFile = new File(userDir, ".history");
                raf = null;
                try {
                    raf = new RandomAccessFile(historyFile, "rw");
                }
                catch (Exception ex) {
                    if (userDir.isDirectory() || userDir.mkdirs()) break block16;
                    return;
                }
            }
            if (raf == null) {
                log.warn((Object)"Failed to open .history");
                return;
            }
            try {
                raf.seek(raf.length());
                raf.write(new String(cmd + System.getProperty("line.separator")).getBytes("UTF-8"));
            }
            catch (Exception ex) {
                log.warn((Object)"Failed to write to .history");
            }
            finally {
                try {
                    raf.close();
                }
                catch (Exception ex) {}
            }
        }

        void processCommand(String cmd) throws Exception {
            if (this.runner == null) {
                this.runner = new PoolRunner();
            }
            this.rjob.setCommand(cmd);
            this.runner.joinJob((Runnable)this.rjob, "SSH Thread");
            if (!this.rjob.onePhased) {
                this.rjob.toPhaseTwo();
                this.runner.runJob((Runnable)this.rjob, "SSH Thread");
            }
        }

        public void addByte(int b) {
            this.unprocessed[this.charsPos++] = (byte)b;
            this.processInput();
        }

        public void addBytes(byte[] buf, int offs, int len) {
            int i = 0;
            while (i < len) {
                int free = this.unprocessed.length - this.charsPos;
                if (free > len) {
                    free = len;
                }
                if (free > buf.length - offs - i) {
                    free = buf.length - offs - i;
                }
                System.arraycopy(buf, offs + i, this.unprocessed, this.charsPos, free);
                i += free;
                this.charsPos += free;
                this.processInput();
            }
        }

        class RunnerJob
        implements Runnable {
            String cmd;
            boolean phaseTwo;
            boolean onePhased;
            boolean ready = true;

            RunnerJob() {
            }

            public void setCommand(String cmd) {
                this.cmd = cmd;
                this.phaseTwo = false;
                this.onePhased = false;
                this.ready = false;
            }

            public void toPhaseTwo() {
                this.phaseTwo = true;
            }

            public boolean ready() {
                return this.ready;
            }

            public void run() {
                try {
                    this.start(this.cmd);
                }
                catch (Throwable th) {
                    this.ready = true;
                    this.onePhased = true;
                    SSHShell.this.writeError(th);
                    SSHShell.this.prompt();
                }
            }

            public void start(String cmd) throws Exception {
                if (!this.phaseTwo) {
                    LineEditor.this.pinf = SSHShell.this.shell.prepareExecution(cmd);
                    if (LineEditor.this.pinf == null) {
                        this.onePhased = true;
                        this.ready = true;
                        SSHShell.this.prompt();
                        return;
                    }
                    BufferInputStream ins = new BufferInputStream((InBuffer)SSHShell.this.shell.getBuffer(LineEditor.this.pinf.procid, 1));
                    ins.setAsyncMode(true);
                    ShellOutputStream outs = new ShellOutputStream((ShellStreamer)SSHShell.this.shell, LineEditor.this.pinf.procid);
                    SSHShell.this.iproc = LineEditor.this.pinf;
                    SSHShell.this.masterOut.setInputStream(ins);
                    SSHShell.this.masterIn.setOutputStream((OutputStream)outs);
                } else {
                    SSHShell.this.shell.completeExecution();
                    this.ready = true;
                }
            }
        }
    }
}

