/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import org.apache.camel.Expression;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.language.simple.SimpleLanguageSupport;
import org.apache.camel.util.ObjectHelper;

public class SimpleLanguage
extends SimpleLanguageSupport {
    public static Expression simple(String expression) {
        SimpleLanguage language = new SimpleLanguage();
        return language.createExpression(expression);
    }

    protected Expression createSimpleExpression(String expression, boolean strict) {
        if (ObjectHelper.isEqualToAny(expression, "body", "in.body")) {
            return ExpressionBuilder.bodyExpression();
        }
        if (ObjectHelper.equal(expression, "out.body")) {
            return ExpressionBuilder.outBodyExpression();
        }
        if (ObjectHelper.equal(expression, "id")) {
            return ExpressionBuilder.messageIdExpression();
        }
        if (ObjectHelper.equal(expression, "exception.message")) {
            return ExpressionBuilder.exchangeExceptionMessageExpression();
        }
        String remainder = this.ifStartsWithReturnRemainder("in.header.", expression);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("header.", expression);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("headers.", expression);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("in.headers.", expression);
        }
        if (remainder != null) {
            return ExpressionBuilder.headerExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("out.header.", expression);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("out.headers.", expression);
        }
        if (remainder != null) {
            return ExpressionBuilder.outHeaderExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("property.", expression);
        if (remainder != null) {
            return ExpressionBuilder.propertyExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("sys.", expression);
        if (remainder != null) {
            return ExpressionBuilder.systemPropertyExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("date:", expression);
        if (remainder != null) {
            String[] parts = remainder.split(":");
            if (parts.length != 2) {
                throw new ExpressionIllegalSyntaxException("Valid syntax: ${date:command:pattern} was: " + expression);
            }
            String command = parts[0];
            String pattern = parts[1];
            return ExpressionBuilder.dateExpression(command, pattern);
        }
        remainder = this.ifStartsWithReturnRemainder("bean:", expression);
        if (remainder != null) {
            return ExpressionBuilder.beanExpression(remainder);
        }
        if (strict) {
            throw new ExpressionIllegalSyntaxException(expression);
        }
        return ExpressionBuilder.constantExpression(expression);
    }

    public boolean isSingleton() {
        return true;
    }
}

