/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CamelContextHelper {
    private CamelContextHelper() {
    }

    public static Endpoint getMandatoryEndpoint(CamelContext camelContext, String uri) throws NoSuchEndpointException {
        Endpoint endpoint = camelContext.getEndpoint(uri);
        if (endpoint == null) {
            throw new NoSuchEndpointException(uri);
        }
        return endpoint;
    }

    public static <T extends Endpoint> T getMandatoryEndpoint(CamelContext camelContext, String uri, Class<T> type) {
        Endpoint endpoint = CamelContextHelper.getMandatoryEndpoint(camelContext, uri);
        return (T)((Endpoint)ObjectHelper.cast(type, endpoint));
    }

    public static <T> T convertTo(CamelContext context, Class<T> type, Object value) {
        ObjectHelper.notNull(context, "camelContext");
        return context.getTypeConverter().convertTo(type, value);
    }

    public static <T> T mandatoryConvertTo(CamelContext context, Class<T> type, Object value) {
        T answer = CamelContextHelper.convertTo(context, type, value);
        if (answer == null) {
            throw new IllegalArgumentException("Value " + value + " converted to " + type.getName() + " cannot be null");
        }
        return answer;
    }

    public static <T> T newInstance(CamelContext context, Class<T> beanType) {
        return context.getInjector().newInstance(beanType);
    }

    public static Object lookup(CamelContext context, String name) {
        return context.getRegistry().lookup(name);
    }

    public static <T> T lookup(CamelContext context, String name, Class<T> beanType) {
        return context.getRegistry().lookup(name, beanType);
    }

    public static Object mandatoryLookup(CamelContext context, String name) {
        Object answer = CamelContextHelper.lookup(context, name);
        ObjectHelper.notNull(answer, "registry entry called " + name);
        return answer;
    }

    public static <T> T mandatoryLookup(CamelContext context, String name, Class<T> beanType) {
        T answer = CamelContextHelper.lookup(context, name, beanType);
        ObjectHelper.notNull(answer, "registry entry called " + name + " of type " + beanType.getName());
        return answer;
    }

    public static Endpoint getEndpointInjection(CamelContext camelContext, String uri, String name, String injectionPointName, boolean mandatory) {
        Endpoint endpoint = null;
        if (ObjectHelper.isNotEmpty(uri)) {
            endpoint = camelContext.getEndpoint(uri);
        } else {
            if (ObjectHelper.isEmpty(name)) {
                name = injectionPointName;
            }
            endpoint = mandatory ? CamelContextHelper.mandatoryLookup(camelContext, name, Endpoint.class) : CamelContextHelper.lookup(camelContext, name, Endpoint.class);
        }
        return endpoint;
    }
}

