/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.Iterator;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EndpointHelper {
    private static final transient Log LOG = LogFactory.getLog(EndpointHelper.class);

    private EndpointHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pollEndpoint(Endpoint endpoint, Processor processor, long timeout) throws Exception {
        PollingConsumer consumer = endpoint.createPollingConsumer();
        try {
            Exchange exchange;
            consumer.start();
            while ((exchange = consumer.receive(timeout)) != null) {
                processor.process(exchange);
            }
        }
        finally {
            try {
                consumer.stop();
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to stop PollingConsumer: " + e), (Throwable)e);
            }
        }
    }

    public static void pollEndpoint(Endpoint endpoint, Processor processor) throws Exception {
        EndpointHelper.pollEndpoint(endpoint, processor, 1000L);
    }

    public static boolean matchEndpoint(String uri, String pattern) {
        if (uri.indexOf("://") != -1) {
            String scheme = ObjectHelper.before(uri, "://");
            String path = ObjectHelper.after(uri, "://");
            if (EndpointHelper.doMatchEndpoint(scheme + ":" + path, pattern)) {
                return true;
            }
        } else {
            String scheme = ObjectHelper.before(uri, ":");
            String path = ObjectHelper.after(uri, ":");
            if (EndpointHelper.doMatchEndpoint(scheme + "://" + path, pattern)) {
                return true;
            }
        }
        return EndpointHelper.doMatchEndpoint(uri, pattern);
    }

    private static boolean doMatchEndpoint(String uri, String pattern) {
        if (uri.equals(pattern)) {
            return true;
        }
        if (pattern.endsWith("*") && uri.startsWith(pattern.substring(0, pattern.length() - 1))) {
            return true;
        }
        try {
            if (uri.matches(pattern)) {
                return true;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return false;
    }

    public static void setProperties(CamelContext context, Object bean, Map<String, Object> parameters) throws Exception {
        IntrospectionSupport.setProperties(context.getTypeConverter(), bean, parameters);
    }

    public static void setReferenceProperties(CamelContext context, Object bean, Map<String, Object> parameters) throws Exception {
        Iterator<Map.Entry<String, Object>> it = parameters.entrySet().iterator();
        while (it.hasNext()) {
            boolean hit;
            Object ref;
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey();
            Object v = entry.getValue();
            String value = v != null ? v.toString() : null;
            if (value == null || !EndpointHelper.isReferenceParameter(value) || (ref = EndpointHelper.resolveReferenceParameter(context, value, Object.class)) == null || !(hit = IntrospectionSupport.setProperty(context.getTypeConverter(), bean, name, ref))) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Configured property: " + name + " on bean: " + bean + " with value: " + ref));
            }
            it.remove();
        }
    }

    public static boolean isReferenceParameter(String parameter) {
        return parameter != null && parameter.startsWith("#");
    }

    public static <T> T resolveReferenceParameter(CamelContext context, String value, Class<T> type) {
        assert (EndpointHelper.isReferenceParameter(value));
        return context.getRegistry().lookup(value.substring(1), type);
    }
}

