/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.direct.DirectEndpoint;
import org.apache.camel.impl.DefaultConsumer;

public class DirectConsumer
extends DefaultConsumer {
    private DirectEndpoint endpoint;

    public DirectConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = (DirectEndpoint)endpoint;
    }

    public void start() throws Exception {
        if (!this.endpoint.getConsumers().contains(this)) {
            if (!this.endpoint.getConsumers().isEmpty()) {
                throw new IllegalStateException("Endpoint " + this.endpoint.getEndpointUri() + " only allows 1 active consumer but you attempted to start a 2nd consumer.");
            }
            this.endpoint.getConsumers().add(this);
        }
        super.start();
    }

    public void stop() throws Exception {
        super.stop();
        this.endpoint.getConsumers().remove(this);
    }
}

